/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.exception.AxelorException;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.math.BigDecimal;
import java.util.Map;

public interface SaleOrderLineService {
    public void computeProductInformation(SaleOrderLine var1, SaleOrder var2, Integer var3) throws AxelorException;

    public SaleOrderLine resetProductInformation(SaleOrderLine var1);

    public Map<String, BigDecimal> computeValues(SaleOrder var1, SaleOrderLine var2) throws AxelorException;

    public BigDecimal computeAmount(SaleOrderLine var1);

    public BigDecimal computeAmount(BigDecimal var1, BigDecimal var2);

    public BigDecimal getExTaxUnitPrice(SaleOrder var1, SaleOrderLine var2, TaxLine var3) throws AxelorException;

    public BigDecimal getInTaxUnitPrice(SaleOrder var1, SaleOrderLine var2, TaxLine var3) throws AxelorException;

    public TaxLine getTaxLine(SaleOrder var1, SaleOrderLine var2) throws AxelorException;

    public BigDecimal getAmountInCompanyCurrency(BigDecimal var1, SaleOrder var2) throws AxelorException;

    public BigDecimal getCompanyCostPrice(SaleOrder var1, SaleOrderLine var2) throws AxelorException;

    public PriceListLine getPriceListLine(SaleOrderLine var1, PriceList var2, BigDecimal var3);

    public BigDecimal computeDiscount(SaleOrderLine var1, Boolean var2);

    public BigDecimal convertUnitPrice(Boolean var1, TaxLine var2, BigDecimal var3);

    public Map<String, Object> getDiscountsFromPriceLists(SaleOrder var1, SaleOrderLine var2, BigDecimal var3);

    public int getDiscountTypeSelect(SaleOrder var1, SaleOrderLine var2, BigDecimal var3);

    public Unit getSaleUnit(SaleOrderLine var1);

    public BigDecimal computeTotalPack(SaleOrderLine var1);

    public SaleOrder getSaleOrder(Context var1);

    public Map<String, BigDecimal> computeSubMargin(SaleOrder var1, SaleOrderLine var2) throws AxelorException;

    public BigDecimal getAvailableStock(SaleOrder var1, SaleOrderLine var2);

    public BigDecimal getAllocatedStock(SaleOrder var1, SaleOrderLine var2);

    public void checkMultipleQty(SaleOrderLine var1, ActionResponse var2);

    public void fillPrice(SaleOrderLine var1, SaleOrder var2, Integer var3) throws AxelorException;

    public boolean checkTaxRequired(SaleOrderLine var1, Integer var2);
}

