/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductMultipleQtyService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.sale.db.PackLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderLineServiceImpl
implements SaleOrderLineService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected CurrencyService currencyService;
    @Inject
    protected PriceListService priceListService;
    @Inject
    protected ProductMultipleQtyService productMultipleQtyService;
    @Inject
    protected AppSaleService appSaleService;
    @Inject
    protected AccountManagementService accountManagementService;

    @Override
    public void computeProductInformation(SaleOrderLine saleOrderLine, SaleOrder saleOrder, Integer packPriceSelect) throws AxelorException {
        saleOrderLine.setProductName(saleOrderLine.getProduct().getName());
        saleOrderLine.setUnit(this.getSaleUnit(saleOrderLine));
        if (this.appSaleService.getAppSale().getIsEnabledProductDescriptionCopy().booleanValue()) {
            saleOrderLine.setDescription(saleOrderLine.getProduct().getDescription());
        }
        saleOrderLine.setTypeSelect(0);
        saleOrderLine.setSubLineList(null);
        saleOrderLine.setPackPriceSelect(null);
        saleOrderLine.setDiscountTypeSelect(0);
        if (this.appSaleService.getAppSale().getProductPackMgt().booleanValue() && saleOrderLine.getProduct().getProductTypeSelect().equals("pack") && !saleOrderLine.getIsSubLine().booleanValue()) {
            saleOrderLine.setTypeSelect(2);
            saleOrderLine.setPackPriceSelect(packPriceSelect);
            saleOrderLine.setSubLineList(this.createPackLines(saleOrderLine, saleOrder));
        }
        this.fillPrice(saleOrderLine, saleOrder, packPriceSelect);
    }

    @Override
    public void fillPrice(SaleOrderLine saleOrderLine, SaleOrder saleOrder, Integer packPriceSelect) throws AxelorException {
        boolean taxRequired = this.checkTaxRequired(saleOrderLine, packPriceSelect);
        if (taxRequired) {
            this.fillTaxInformation(saleOrderLine, saleOrder);
            saleOrderLine.setCompanyCostPrice(this.getCompanyCostPrice(saleOrder, saleOrderLine));
            if (saleOrderLine.getProduct().getInAti().booleanValue()) {
                BigDecimal inTaxPrice = this.getInTaxUnitPrice(saleOrder, saleOrderLine, saleOrderLine.getTaxLine());
                inTaxPrice = this.fillDiscount(saleOrderLine, saleOrder, inTaxPrice);
                saleOrderLine.setInTaxPrice(inTaxPrice);
                saleOrderLine.setPrice(this.convertUnitPrice(true, saleOrderLine.getTaxLine(), inTaxPrice));
            } else {
                BigDecimal exTaxPrice = this.getExTaxUnitPrice(saleOrder, saleOrderLine, saleOrderLine.getTaxLine());
                exTaxPrice = this.fillDiscount(saleOrderLine, saleOrder, exTaxPrice);
                saleOrderLine.setPrice(exTaxPrice);
                saleOrderLine.setInTaxPrice(this.convertUnitPrice(false, saleOrderLine.getTaxLine(), exTaxPrice));
            }
        } else {
            saleOrderLine.setPrice(BigDecimal.ZERO);
            saleOrderLine.setInTaxPrice(BigDecimal.ZERO);
            saleOrderLine.setDiscountAmount(BigDecimal.ZERO);
            saleOrderLine.setDiscountTypeSelect(0);
            saleOrderLine.setCompanyCostPrice(BigDecimal.ZERO);
        }
    }

    protected List<SaleOrderLine> createPackLines(SaleOrderLine saleOrderLine, SaleOrder saleOrder) throws AxelorException {
        ArrayList<SaleOrderLine> subLines = new ArrayList<SaleOrderLine>();
        Integer sequence = saleOrderLine.getSequence();
        if (sequence == null) {
            sequence = 0;
        }
        if (saleOrder.getSaleOrderLineList() != null && sequence == 0) {
            for (SaleOrderLine orderLine : saleOrder.getSaleOrderLineList()) {
                if (orderLine.getSequence() <= sequence) continue;
                sequence = orderLine.getSequence();
            }
        }
        if (saleOrderLine.getSequence() == null) {
            sequence = sequence + 1;
            saleOrderLine.setSequence(sequence);
        }
        for (PackLine packLine : saleOrderLine.getProduct().getPackLines()) {
            SaleOrderLine subLine = new SaleOrderLine();
            Product subProduct = packLine.getProduct();
            subLine.setProduct(subProduct);
            subLine.setQty(new BigDecimal(packLine.getQuantity()).multiply(saleOrderLine.getQty()));
            subLine.setIsSubLine(true);
            this.computeProductInformation(subLine, saleOrder, saleOrderLine.getPackPriceSelect());
            this.computeValues(saleOrder, subLine);
            sequence = sequence + 1;
            subLine.setSequence(sequence);
            subLines.add(subLine);
        }
        return subLines;
    }

    protected BigDecimal fillDiscount(SaleOrderLine saleOrderLine, SaleOrder saleOrder, BigDecimal price) {
        Map<String, Object> discounts = this.getDiscountsFromPriceLists(saleOrder, saleOrderLine, price);
        if (discounts != null) {
            if (discounts.get("price") != null) {
                price = (BigDecimal)discounts.get("price");
            }
            if (saleOrderLine.getProduct().getInAti() != saleOrder.getInAti() && (Integer)discounts.get("discountTypeSelect") != 1) {
                saleOrderLine.setDiscountAmount(this.convertUnitPrice(saleOrderLine.getProduct().getInAti(), saleOrderLine.getTaxLine(), (BigDecimal)discounts.get("discountAmount")));
            } else {
                saleOrderLine.setDiscountAmount((BigDecimal)discounts.get("discountAmount"));
            }
            saleOrderLine.setDiscountTypeSelect((Integer)discounts.get("discountTypeSelect"));
        } else if (!saleOrder.getTemplate().booleanValue()) {
            saleOrderLine.setDiscountAmount(BigDecimal.ZERO);
            saleOrderLine.setDiscountTypeSelect(0);
        }
        return price;
    }

    protected void fillTaxInformation(SaleOrderLine saleOrderLine, SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getClientPartner() != null) {
            TaxLine taxLine = this.getTaxLine(saleOrder, saleOrderLine);
            saleOrderLine.setTaxLine(taxLine);
            FiscalPosition fiscalPosition = saleOrder.getClientPartner().getFiscalPosition();
            Tax tax = this.accountManagementService.getProductTax(saleOrderLine.getProduct(), saleOrder.getCompany(), fiscalPosition, false);
            TaxEquiv taxEquiv = ((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(fiscalPosition, tax);
            saleOrderLine.setTaxEquiv(taxEquiv);
        } else {
            saleOrderLine.setTaxLine(null);
            saleOrderLine.setTaxEquiv(null);
        }
    }

    @Override
    public boolean checkTaxRequired(SaleOrderLine saleOrderLine, Integer packPriceSelect) {
        if (this.appSaleService.getAppSale().getProductPackMgt().booleanValue()) {
            if (saleOrderLine.getIsSubLine().booleanValue() && packPriceSelect != null && packPriceSelect == 0) {
                return false;
            }
            if (saleOrderLine.getTypeSelect() == 2 && packPriceSelect != null && packPriceSelect == 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    public SaleOrderLine resetProductInformation(SaleOrderLine line) {
        line.setTaxLine(null);
        line.setTaxEquiv(null);
        line.setProductName(null);
        line.setUnit(null);
        line.setCompanyCostPrice(null);
        line.setDiscountAmount(null);
        line.setDiscountTypeSelect(0);
        line.setPrice(null);
        line.setInTaxPrice(null);
        line.setExTaxTotal(null);
        line.setInTaxTotal(null);
        line.setCompanyInTaxTotal(null);
        line.setCompanyExTaxTotal(null);
        if (this.appSaleService.getAppSale().getIsEnabledProductDescriptionCopy().booleanValue()) {
            line.setDescription(null);
        }
        return line;
    }

    @Override
    public Map<String, BigDecimal> computeValues(SaleOrder saleOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        BigDecimal companyInTaxTotal;
        BigDecimal companyExTaxTotal;
        BigDecimal inTaxTotal;
        BigDecimal exTaxTotal;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (saleOrder == null || saleOrderLine.getPrice() == null || saleOrderLine.getInTaxPrice() == null || saleOrderLine.getQty() == null) {
            return map;
        }
        BigDecimal priceDiscounted = this.computeDiscount(saleOrderLine, saleOrder.getInAti());
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal subTotalCostPrice = BigDecimal.ZERO;
        if (saleOrderLine.getTaxLine() != null) {
            taxRate = saleOrderLine.getTaxLine().getValue();
        }
        if (!saleOrder.getInAti().booleanValue()) {
            exTaxTotal = this.computeAmount(saleOrderLine.getQty(), priceDiscounted);
            inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
            companyExTaxTotal = this.getAmountInCompanyCurrency(exTaxTotal, saleOrder);
            companyInTaxTotal = companyExTaxTotal.add(companyExTaxTotal.multiply(taxRate));
        } else {
            inTaxTotal = this.computeAmount(saleOrderLine.getQty(), priceDiscounted);
            exTaxTotal = inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
            companyInTaxTotal = this.getAmountInCompanyCurrency(inTaxTotal, saleOrder);
            companyExTaxTotal = companyInTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 4);
        }
        if (saleOrderLine.getProduct() != null && saleOrderLine.getProduct().getCostPrice().compareTo(BigDecimal.ZERO) != 0) {
            subTotalCostPrice = saleOrderLine.getProduct().getCostPrice().multiply(saleOrderLine.getQty());
        }
        saleOrderLine.setInTaxTotal(inTaxTotal);
        saleOrderLine.setExTaxTotal(exTaxTotal);
        saleOrderLine.setPriceDiscounted(priceDiscounted);
        saleOrderLine.setCompanyInTaxTotal(companyInTaxTotal);
        saleOrderLine.setCompanyExTaxTotal(companyExTaxTotal);
        saleOrderLine.setSubTotalCostPrice(subTotalCostPrice);
        map.put("inTaxTotal", inTaxTotal);
        map.put("exTaxTotal", exTaxTotal);
        map.put("priceDiscounted", priceDiscounted);
        map.put("companyExTaxTotal", companyExTaxTotal);
        map.put("companyInTaxTotal", companyInTaxTotal);
        map.put("subTotalCostPrice", subTotalCostPrice);
        map.putAll(this.computeSubMargin(saleOrder, saleOrderLine));
        return map;
    }

    @Override
    public BigDecimal computeAmount(SaleOrderLine saleOrderLine) {
        BigDecimal price = this.computeDiscount(saleOrderLine, false);
        return this.computeAmount(saleOrderLine.getQty(), price);
    }

    @Override
    public BigDecimal computeAmount(BigDecimal quantity, BigDecimal price) {
        BigDecimal amount = quantity.multiply(price).setScale(2, RoundingMode.HALF_EVEN);
        this.logger.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{quantity, price, amount});
        return amount;
    }

    @Override
    public BigDecimal getExTaxUnitPrice(SaleOrder saleOrder, SaleOrderLine saleOrderLine, TaxLine taxLine) throws AxelorException {
        return this.getUnitPrice(saleOrder, saleOrderLine, taxLine, false);
    }

    @Override
    public BigDecimal getInTaxUnitPrice(SaleOrder saleOrder, SaleOrderLine saleOrderLine, TaxLine taxLine) throws AxelorException {
        return this.getUnitPrice(saleOrder, saleOrderLine, taxLine, true);
    }

    private BigDecimal getUnitPrice(SaleOrder saleOrder, SaleOrderLine saleOrderLine, TaxLine taxLine, boolean resultInAti) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        BigDecimal price = product.getInAti() == resultInAti ? product.getSalePrice() : this.convertUnitPrice(product.getInAti(), taxLine, product.getSalePrice());
        return this.currencyService.getAmountCurrencyConvertedAtDate(product.getSaleCurrency(), saleOrder.getCurrency(), price, saleOrder.getCreationDate()).setScale(this.appSaleService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
    }

    @Override
    public TaxLine getTaxLine(SaleOrder saleOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        return ((AccountManagementService)Beans.get(AccountManagementService.class)).getTaxLine(saleOrder.getCreationDate(), saleOrderLine.getProduct(), saleOrder.getCompany(), saleOrder.getClientPartner().getFiscalPosition(), false);
    }

    @Override
    public BigDecimal getAmountInCompanyCurrency(BigDecimal exTaxTotal, SaleOrder saleOrder) throws AxelorException {
        return this.currencyService.getAmountCurrencyConvertedAtDate(saleOrder.getCurrency(), saleOrder.getCompany().getCurrency(), exTaxTotal, saleOrder.getCreationDate()).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getCompanyCostPrice(SaleOrder saleOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        return this.currencyService.getAmountCurrencyConvertedAtDate(product.getPurchaseCurrency(), saleOrder.getCompany().getCurrency(), product.getCostPrice(), saleOrder.getCreationDate()).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public PriceListLine getPriceListLine(SaleOrderLine saleOrderLine, PriceList priceList, BigDecimal price) {
        return this.priceListService.getPriceListLine(saleOrderLine.getProduct(), saleOrderLine.getQty(), priceList, price);
    }

    @Override
    public BigDecimal computeDiscount(SaleOrderLine saleOrderLine, Boolean inAti) {
        BigDecimal price = inAti != false ? saleOrderLine.getInTaxPrice() : saleOrderLine.getPrice();
        return this.priceListService.computeDiscount(price, saleOrderLine.getDiscountTypeSelect().intValue(), saleOrderLine.getDiscountAmount());
    }

    @Override
    public BigDecimal convertUnitPrice(Boolean priceIsAti, TaxLine taxLine, BigDecimal price) {
        if (taxLine == null) {
            return price;
        }
        price = priceIsAti != false ? price.divide(taxLine.getValue().add(BigDecimal.ONE), 2, 4) : price.add(price.multiply(taxLine.getValue()));
        return price;
    }

    @Override
    public Map<String, Object> getDiscountsFromPriceLists(SaleOrder saleOrder, SaleOrderLine saleOrderLine, BigDecimal price) {
        Map discounts = null;
        PriceList priceList = saleOrder.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(saleOrderLine, priceList, price);
            discounts = this.priceListService.getReplacedPriceAndDiscounts(priceList, priceListLine, price);
            if (saleOrder.getTemplate().booleanValue()) {
                Integer manualDiscountAmountType = saleOrderLine.getDiscountTypeSelect();
                BigDecimal manualDiscountAmount = saleOrderLine.getDiscountAmount();
                Integer priceListDiscountAmountType = (Integer)discounts.get("discountTypeSelect");
                BigDecimal priceListDiscountAmount = (BigDecimal)discounts.get("discountAmount");
                if (!manualDiscountAmountType.equals(priceListDiscountAmountType) && manualDiscountAmountType.equals(1) && priceListDiscountAmountType.equals(2)) {
                    priceListDiscountAmount = priceListDiscountAmount.multiply(new BigDecimal(100)).divide(price, 2, RoundingMode.HALF_UP);
                } else if (!manualDiscountAmountType.equals(priceListDiscountAmountType) && manualDiscountAmountType.equals(2) && priceListDiscountAmountType.equals(1)) {
                    priceListDiscountAmount = priceListDiscountAmount.multiply(price).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                }
                if (manualDiscountAmount.compareTo(priceListDiscountAmount) > 0) {
                    discounts.put("discountAmount", manualDiscountAmount);
                    discounts.put("discountTypeSelect", manualDiscountAmountType);
                }
            }
        }
        return discounts;
    }

    @Override
    public int getDiscountTypeSelect(SaleOrder saleOrder, SaleOrderLine saleOrderLine, BigDecimal price) {
        PriceList priceList = saleOrder.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(saleOrderLine, priceList, price);
            return priceListLine.getTypeSelect();
        }
        return 0;
    }

    @Override
    public Unit getSaleUnit(SaleOrderLine saleOrderLine) {
        Unit unit = saleOrderLine.getProduct().getSalesUnit();
        if (unit == null) {
            unit = saleOrderLine.getProduct().getUnit();
        }
        return unit;
    }

    @Override
    public BigDecimal computeTotalPack(SaleOrderLine saleOrderLine) {
        BigDecimal totalPack = BigDecimal.ZERO;
        if (saleOrderLine.getSubLineList() != null) {
            for (SaleOrderLine subLine : saleOrderLine.getSubLineList()) {
                totalPack = totalPack.add(subLine.getInTaxTotal());
            }
        }
        return totalPack;
    }

    @Override
    public SaleOrder getSaleOrder(Context context) {
        Context parentContext = context.getParent();
        SaleOrderLine saleOrderLine = (SaleOrderLine)((Object)context.asType(SaleOrderLine.class));
        SaleOrder saleOrder = saleOrderLine.getSaleOrder();
        if (parentContext != null && !parentContext.getContextClass().equals(SaleOrder.class)) {
            parentContext = parentContext.getParent();
        }
        if (parentContext != null && parentContext.getContextClass().equals(SaleOrder.class)) {
            saleOrder = (SaleOrder)((Object)parentContext.asType(SaleOrder.class));
        }
        return saleOrder;
    }

    @Override
    public Map<String, BigDecimal> computeSubMargin(SaleOrder saleOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal subTotalCostPrice = BigDecimal.ZERO;
        BigDecimal subTotalGrossProfit = BigDecimal.ZERO;
        BigDecimal subMarginRate = BigDecimal.ZERO;
        BigDecimal subTotalMarkup = BigDecimal.ZERO;
        BigDecimal totalWT = BigDecimal.ZERO;
        if (saleOrderLine.getProduct() != null && saleOrderLine.getProduct().getCostPrice().compareTo(BigDecimal.ZERO) != 0 && saleOrderLine.getExTaxTotal().compareTo(BigDecimal.ZERO) != 0) {
            totalWT = this.currencyService.getAmountCurrencyConvertedAtDate(saleOrder.getCurrency(), saleOrder.getCompany().getCurrency(), saleOrderLine.getExTaxTotal(), null);
            this.logger.debug("Total WT in company currency: {}", (Object)totalWT);
            subTotalCostPrice = saleOrderLine.getSubTotalCostPrice();
            this.logger.debug("Subtotal cost price: {}", (Object)subTotalCostPrice);
            subTotalGrossProfit = totalWT.subtract(subTotalCostPrice);
            this.logger.debug("Subtotal gross margin: {}", (Object)subTotalGrossProfit);
            subMarginRate = subTotalGrossProfit.divide(totalWT, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100));
            this.logger.debug("Subtotal gross margin rate: {}", (Object)subMarginRate);
            if (subTotalCostPrice.compareTo(BigDecimal.ZERO) != 0) {
                subTotalMarkup = subTotalGrossProfit.divide(subTotalCostPrice, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100));
                this.logger.debug("Subtotal markup: {}", (Object)subTotalMarkup);
            }
        }
        saleOrderLine.setSubTotalGrossMargin(subTotalGrossProfit);
        saleOrderLine.setSubMarginRate(subMarginRate);
        saleOrderLine.setSubTotalMarkup(subTotalMarkup);
        map.put("subTotalGrossMargin", subTotalGrossProfit);
        map.put("subMarginRate", subMarginRate);
        map.put("subTotalMarkup", subTotalMarkup);
        return map;
    }

    @Override
    public BigDecimal getAvailableStock(SaleOrder saleOrder, SaleOrderLine saleOrderLine) {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getAllocatedStock(SaleOrder saleOrder, SaleOrderLine saleOrderLine) {
        return BigDecimal.ZERO;
    }

    @Override
    public void checkMultipleQty(SaleOrderLine saleOrderLine, ActionResponse response) {
        Product product = saleOrderLine.getProduct();
        if (product == null) {
            return;
        }
        this.productMultipleQtyService.checkMultipleQty(saleOrderLine.getQty(), product.getSaleProductMultipleQtyList(), product.getAllowToForceSaleQty().booleanValue(), response);
    }
}

