/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.SaleOrderLineTax;
import com.axelor.apps.sale.service.saleorder.SaleOrderToolService;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderLineTaxService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private SaleOrderToolService saleOrderToolService;

    public List<SaleOrderLineTax> createsSaleOrderLineTax(SaleOrder saleOrder, List<SaleOrderLine> saleOrderLineList) {
        ArrayList<SaleOrderLineTax> saleOrderLineTaxList = new ArrayList<SaleOrderLineTax>();
        HashMap<TaxLine, SaleOrderLineTax> map = new HashMap<TaxLine, SaleOrderLineTax>();
        HashSet<String> specificNotes = new HashSet<String>();
        boolean customerSpecificNote = false;
        if (saleOrder.getClientPartner().getFiscalPosition() != null) {
            customerSpecificNote = saleOrder.getClientPartner().getFiscalPosition().getCustomerSpecificNote();
        }
        if (saleOrderLineList != null && !saleOrderLineList.isEmpty()) {
            LOG.debug("Cr\u00e9ation des lignes de tva pour les lignes de factures.");
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                TaxEquiv taxEquiv;
                TaxLine taxLine = saleOrderLine.getTaxLine();
                if (taxLine != null) {
                    SaleOrderLineTax saleOrderLineTax;
                    LOG.debug("Tax {}", (Object)taxLine);
                    if (map.containsKey(taxLine)) {
                        saleOrderLineTax = (SaleOrderLineTax)((Object)map.get(taxLine));
                        saleOrderLineTax.setExTaxBase(saleOrderLineTax.getExTaxBase().add(saleOrderLine.getExTaxTotal()));
                    } else {
                        saleOrderLineTax = new SaleOrderLineTax();
                        saleOrderLineTax.setSaleOrder(saleOrder);
                        saleOrderLineTax.setExTaxBase(saleOrderLine.getExTaxTotal());
                        saleOrderLineTax.setTaxLine(taxLine);
                        map.put(taxLine, saleOrderLineTax);
                    }
                }
                if (customerSpecificNote || (taxEquiv = saleOrderLine.getTaxEquiv()) == null || taxEquiv.getSpecificNote() == null) continue;
                specificNotes.add(taxEquiv.getSpecificNote());
            }
        }
        for (SaleOrderLineTax saleOrderLineTax : map.values()) {
            BigDecimal exTaxBase = saleOrderLineTax.getExTaxBase();
            BigDecimal taxTotal = BigDecimal.ZERO;
            if (saleOrderLineTax.getTaxLine() != null) {
                taxTotal = this.saleOrderToolService.computeAmount(exTaxBase, saleOrderLineTax.getTaxLine().getValue());
                saleOrderLineTax.setTaxTotal(taxTotal);
            }
            saleOrderLineTax.setInTaxTotal(exTaxBase.add(taxTotal));
            saleOrderLineTaxList.add(saleOrderLineTax);
            LOG.debug("Ligne de TVA : Total TVA => {}, Total HT => {}", new Object[]{saleOrderLineTax.getTaxTotal(), saleOrderLineTax.getInTaxTotal()});
        }
        if (!customerSpecificNote) {
            saleOrder.setSpecificNotes(Joiner.on((char)'\n').join(specificNotes));
        } else {
            saleOrder.setSpecificNotes(saleOrder.getClientPartner().getSpecificTaxNote());
        }
        return saleOrderLineTaxList;
    }
}

