/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.saleorder.SaleOrderMarginService;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderMarginServiceImpl
implements SaleOrderMarginService {
    protected final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void computeMarginSaleOrder(SaleOrder saleOrder) {
        BigDecimal accountedRevenue = BigDecimal.ZERO;
        BigDecimal totalCostPrice = BigDecimal.ZERO;
        BigDecimal totalGrossProfit = BigDecimal.ZERO;
        BigDecimal marginRate = BigDecimal.ZERO;
        BigDecimal markup = BigDecimal.ZERO;
        if (saleOrder.getSaleOrderLineList() != null && !saleOrder.getSaleOrderLineList().isEmpty()) {
            for (SaleOrderLine saleOrderLineList : saleOrder.getSaleOrderLineList()) {
                if (saleOrderLineList.getProduct() == null || saleOrderLineList.getSubTotalCostPrice().compareTo(BigDecimal.ZERO) == 0 || saleOrderLineList.getExTaxTotal().compareTo(BigDecimal.ZERO) == 0) continue;
                accountedRevenue = accountedRevenue.add(saleOrderLineList.getCompanyExTaxTotal());
                totalCostPrice = totalCostPrice.add(saleOrderLineList.getSubTotalCostPrice());
                totalGrossProfit = totalGrossProfit.add(saleOrderLineList.getSubTotalGrossMargin());
                marginRate = totalGrossProfit.divide(accountedRevenue, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100));
                markup = totalGrossProfit.divide(totalCostPrice, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100));
            }
        }
        saleOrder.setAccountedRevenue(accountedRevenue);
        saleOrder.setTotalCostPrice(totalCostPrice);
        saleOrder.setTotalGrossMargin(totalGrossProfit);
        saleOrder.setMarginRate(marginRate);
        saleOrder.setMarkup(markup);
    }
}

