/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.DurationService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderServiceImpl
implements SaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public String getFileName(SaleOrder saleOrder) {
        return I18n.get((String)"Sale order") + " " + saleOrder.getSaleOrderSeq() + (saleOrder.getVersionNumber() > 1 ? "-V" + saleOrder.getVersionNumber() : "");
    }

    @Override
    public SaleOrder computeEndOfValidityDate(SaleOrder saleOrder) {
        if (saleOrder.getDuration() != null && saleOrder.getCreationDate() != null) {
            saleOrder.setEndOfValidityDate(((DurationService)Beans.get(DurationService.class)).computeDuration(saleOrder.getDuration(), saleOrder.getCreationDate()));
        }
        return saleOrder;
    }

    @Override
    @Deprecated
    public String getReportLink(SaleOrder saleOrder, String name, String language, boolean proforma, String format) throws AxelorException {
        return ReportFactory.createReport((String)"SaleOrder.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)language).addParam("SaleOrderId", (Object)saleOrder.getId()).addParam("ProformaInvoice", (Object)proforma).addFormat(format).generate().getFileLink();
    }

    @Override
    public void computeAddressStr(SaleOrder saleOrder) {
        AddressService addressService = (AddressService)Beans.get(AddressService.class);
        saleOrder.setMainInvoicingAddressStr(addressService.computeAddressStr(saleOrder.getMainInvoicingAddress()));
        saleOrder.setDeliveryAddressStr(addressService.computeAddressStr(saleOrder.getDeliveryAddress()));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public boolean enableEditOrder(SaleOrder saleOrder) throws AxelorException {
        if (saleOrder.getStatusSelect() == 4) {
            throw new AxelorException((Model)((Object)saleOrder), 5, I18n.get((String)"This sale order is completed."));
        }
        saleOrder.setOrderBeingEdited(true);
        return false;
    }

    @Override
    public void checkModifiedConfirmedOrder(SaleOrder saleOrder, SaleOrder saleOrderView) throws AxelorException {
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validateChanges(SaleOrder saleOrder) throws AxelorException {
    }

    @Override
    public void sortSaleOrderLineList(SaleOrder saleOrder) {
        if (saleOrder.getSaleOrderLineList() != null) {
            saleOrder.getSaleOrderLineList().sort(Comparator.comparing(SaleOrderLine::getSequence));
        }
    }
}

