/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.sale.db.Configurator;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.ConfiguratorRepository;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorService;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.JsonContext;
import com.google.inject.Singleton;

@Singleton
public class ConfiguratorController {
    public void updateIndicators(ActionRequest request, ActionResponse response) {
        Configurator configurator = (Configurator)((Object)request.getContext().asType(Configurator.class));
        JsonContext jsonAttributes = (JsonContext)request.getContext().get((Object)"$attributes");
        JsonContext jsonIndicators = (JsonContext)request.getContext().get((Object)"$indicators");
        configurator = (Configurator)((Object)((ConfiguratorRepository)((Object)Beans.get(ConfiguratorRepository.class))).find(configurator.getId()));
        try {
            ((ConfiguratorService)Beans.get(ConfiguratorService.class)).updateIndicators(configurator, jsonAttributes, jsonIndicators);
            response.setValue("indicators", request.getContext().get((Object)"indicators"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateProduct(ActionRequest request, ActionResponse response) {
        Configurator configurator = (Configurator)((Object)request.getContext().asType(Configurator.class));
        JsonContext jsonAttributes = (JsonContext)request.getContext().get((Object)"$attributes");
        JsonContext jsonIndicators = (JsonContext)request.getContext().get((Object)"$indicators");
        configurator = (Configurator)((Object)((ConfiguratorRepository)((Object)Beans.get(ConfiguratorRepository.class))).find(configurator.getId()));
        try {
            ((ConfiguratorService)Beans.get(ConfiguratorService.class)).generate(configurator, jsonAttributes, jsonIndicators);
            response.setReload(true);
            if (configurator.getProduct() != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Product generated")).model(Product.class.getName()).add("form", "product-form").add("grid", "product-grid").context("_showRecord", (Object)configurator.getProduct().getId()).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
    }

    public void generateForSaleOrder(ActionRequest request, ActionResponse response) {
        Configurator configurator = (Configurator)((Object)request.getContext().asType(Configurator.class));
        long saleOrderId = ((Integer)request.getContext().get((Object)"_saleOrderId")).longValue();
        JsonContext jsonAttributes = (JsonContext)request.getContext().get((Object)"$attributes");
        JsonContext jsonIndicators = (JsonContext)request.getContext().get((Object)"$indicators");
        configurator = (Configurator)((Object)((ConfiguratorRepository)((Object)Beans.get(ConfiguratorRepository.class))).find(configurator.getId()));
        SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrderId));
        try {
            ((ConfiguratorService)Beans.get(ConfiguratorService.class)).addLineToSaleOrder(configurator, saleOrder, jsonAttributes, jsonIndicators);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void createDomainForCreator(ActionRequest request, ActionResponse response) {
        response.setAttr("configuratorCreator", "domain", (Object)((ConfiguratorCreatorService)Beans.get(ConfiguratorCreatorService.class)).getConfiguratorCreatorDomain());
    }
}

