/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.web;

import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.service.saleorder.OpportunitySaleOrderService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class OpportunitySaleOrderController {
    public void generateSaleOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        Opportunity opportunity = (Opportunity)((Object)request.getContext().asType(Opportunity.class));
        opportunity = (Opportunity)((Object)((OpportunityRepository)((Object)Beans.get(OpportunityRepository.class))).find(opportunity.getId()));
        SaleOrder saleOrder = ((OpportunitySaleOrderService)Beans.get(OpportunitySaleOrderService.class)).createSaleOrderFromOpportunity(opportunity);
        response.setReload(true);
        response.setView(ActionView.define((String)I18n.get((String)"Sale quotation")).model(SaleOrder.class.getName()).add("form", "sale-order-form").param("forceEdit", "true").param("forceTitle", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).map());
    }

    public void cancelSaleOrders(ActionRequest request, ActionResponse response) {
        List<SaleOrder> saleOrderList;
        Opportunity opportunity = (Opportunity)((Object)request.getContext().asType(Opportunity.class));
        SaleOrderWorkflowService saleOrderWorkflowService = (SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class);
        if (opportunity.getSalesStageSelect() == 6 && (saleOrderList = opportunity.getSaleOrderList()) != null && !saleOrderList.isEmpty()) {
            for (SaleOrder saleOrder : saleOrderList) {
                if (saleOrder.getStatusSelect() != 1 && saleOrder.getStatusSelect() != 2) continue;
                saleOrderWorkflowService.cancelSaleOrder(saleOrder, null, opportunity.getName());
            }
        }
    }
}

