/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.web;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.CurrencyRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.db.repo.PriceListRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateService;
import com.axelor.apps.sale.service.saleorder.SaleOrderMarginService;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowService;
import com.axelor.apps.sale.service.saleorder.SaleOrderWorkflowServiceImpl;
import com.axelor.apps.sale.service.saleorder.print.SaleOrderPrintService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.team.db.Team;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SaleOrderController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void compute(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            saleOrder = ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class)).computeSaleOrder(saleOrder);
            response.setValues((Object)saleOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeMargin(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            ((SaleOrderMarginService)Beans.get(SaleOrderMarginService.class)).computeMarginSaleOrder(saleOrder);
            response.setValue("accountedRevenue", (Object)saleOrder.getAccountedRevenue());
            response.setValue("totalCostPrice", (Object)saleOrder.getTotalCostPrice());
            response.setValue("totalGrossMargin", (Object)saleOrder.getTotalGrossMargin());
            response.setValue("marginRate", (Object)saleOrder.getMarginRate());
            response.setValue("markup", (Object)saleOrder.getMarkup());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showSaleOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        this.exportSaleOrder(request, response, false, "pdf");
    }

    public void printProformaInvoice(ActionRequest request, ActionResponse response) throws AxelorException {
        this.exportSaleOrder(request, response, true, "pdf");
    }

    public void exportSaleOrderExcel(ActionRequest request, ActionResponse response) throws AxelorException {
        this.exportSaleOrder(request, response, false, "xls");
    }

    public void exportSaleOrderWord(ActionRequest request, ActionResponse response) throws AxelorException {
        this.exportSaleOrder(request, response, false, "doc");
    }

    public void exportSaleOrder(ActionRequest request, ActionResponse response, boolean proforma, String format) {
        Context context = request.getContext();
        SaleOrderPrintService saleOrderPrintService = (SaleOrderPrintService)Beans.get(SaleOrderPrintService.class);
        try {
            String title;
            String fileLink;
            if (!ObjectUtils.isEmpty((Object)request.getContext().get((Object)"_ids"))) {
                List ids = Lists.transform((List)((List)request.getContext().get((Object)"_ids")), (Function)new Function<Object, Long>(){

                    @Nullable
                    public Long apply(@Nullable Object input) {
                        return Long.parseLong(input.toString());
                    }
                });
                fileLink = saleOrderPrintService.printSaleOrders(ids);
                title = I18n.get((String)"Sale orders");
            } else if (context.get((Object)"id") != null) {
                SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
                title = ((SaleOrderService)Beans.get(SaleOrderService.class)).getFileName(saleOrder);
                fileLink = saleOrderPrintService.printSaleOrder(saleOrder, proforma, format);
                this.logger.debug("Printing " + title);
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the sale order(s) to print."));
            }
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelSaleOrder(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        ((SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class)).cancelSaleOrder((SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId())), saleOrder.getCancelReason(), saleOrder.getCancelReasonStr());
        response.setFlash(I18n.get((String)"The sale order was canceled"));
        response.setCanClose(true);
    }

    public void finalizeQuotation(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
        try {
            ((SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class)).finalizeQuotation(saleOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void completeSaleOrder(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
        try {
            ((SaleOrderWorkflowServiceImpl)Beans.get(SaleOrderWorkflowServiceImpl.class)).completeSaleOrder(saleOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void confirmSaleOrder(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            ((SaleOrderWorkflowService)Beans.get(SaleOrderWorkflowService.class)).confirmSaleOrder((SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateViewSaleOrder(ActionRequest request, ActionResponse response) {
        LinkedHashMap saleOrderTemplateContext = (LinkedHashMap)request.getContext().get((Object)"_saleOrderTemplate");
        Integer saleOrderId = (Integer)saleOrderTemplateContext.get("id");
        SaleOrder context = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find((long)saleOrderId));
        response.setView(ActionView.define((String)"Sale order").model(SaleOrder.class.getName()).add("form", "sale-order-form-wizard").context("_idCopy", (Object)context.getId().toString()).context("_wizardCurrency", request.getContext().get((Object)"currency")).context("_wizardPriceList", request.getContext().get((Object)"priceList")).map());
        response.setCanClose(true);
    }

    public void generateViewTemplate(ActionRequest request, ActionResponse response) {
        SaleOrder context = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        response.setView(ActionView.define((String)"Template").model(SaleOrder.class.getName()).add("form", "sale-order-template-form-wizard").context("_idCopy", (Object)context.getId().toString()).map());
    }

    public void generateSaleOrderWizard(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrderTemplate = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        Partner clientPartner = saleOrderTemplate.getClientPartner();
        response.setView(ActionView.define((String)"Create the quotation").model(Wizard.class.getName()).add("form", "sale-order-template-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("width", "large").param("popup-save", "false").context("_saleOrderTemplate", (Object)saleOrderTemplate).context("_clientPartnerCurrency", (Object)clientPartner.getCurrency()).map());
    }

    public void createSaleOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder origin = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(Long.parseLong(request.getContext().get((Object)"_idCopy").toString())));
        if (origin != null) {
            LinkedHashMap wizardCurrencyContext = (LinkedHashMap)request.getContext().get((Object)"_wizardCurrency");
            Integer wizardCurrencyId = (Integer)wizardCurrencyContext.get("id");
            Currency wizardCurrency = (Currency)((CurrencyRepository)Beans.get(CurrencyRepository.class)).find(Long.valueOf(wizardCurrencyId.intValue()));
            PriceList wizardPriceList = null;
            if (request.getContext().get((Object)"_wizardPriceList") != null) {
                LinkedHashMap wizardPriceListContext = (LinkedHashMap)request.getContext().get((Object)"_wizardPriceList");
                Integer wizardPriceListId = (Integer)wizardPriceListContext.get("id");
                wizardPriceList = (PriceList)((PriceListRepository)Beans.get(PriceListRepository.class)).find(Long.valueOf(wizardPriceListId.intValue()));
            }
            SaleOrder copy = ((SaleOrderCreateService)Beans.get(SaleOrderCreateService.class)).createSaleOrder(origin, wizardCurrency, wizardPriceList);
            response.setValues((Object)Mapper.toMap((Object)((Object)copy)));
        }
    }

    public void createTemplate(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        if (context.get((Object)"_idCopy") != null) {
            String idCopy = context.get((Object)"_idCopy").toString();
            SaleOrder origin = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(Long.parseLong(idCopy)));
            SaleOrder copy = ((SaleOrderCreateService)Beans.get(SaleOrderCreateService.class)).createTemplate(origin);
            response.setValues((Object)Mapper.toMap((Object)((Object)copy)));
        }
    }

    public void computeEndOfValidityDate(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        try {
            saleOrder = ((SaleOrderService)Beans.get(SaleOrderService.class)).computeEndOfValidityDate(saleOrder);
            response.setValue("endOfValidityDate", (Object)saleOrder.getEndOfValidityDate());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void mergeSaleOrder(ActionRequest request, ActionResponse response) {
        ArrayList<SaleOrder> saleOrderList = new ArrayList<SaleOrder>();
        ArrayList<Long> saleOrderIdList = new ArrayList<Long>();
        boolean fromPopup = false;
        String lineToMerge = request.getContext().get((Object)"saleQuotationToMerge") != null ? "saleQuotationToMerge" : "saleOrderToMerge";
        if (request.getContext().get((Object)lineToMerge) != null) {
            if (request.getContext().get((Object)lineToMerge) instanceof List) {
                List saleOrderMap = (List)request.getContext().get((Object)lineToMerge);
                for (Map map : saleOrderMap) {
                    saleOrderIdList.add(new Long(((Integer)map.get("id")).intValue()));
                }
            } else {
                String saleOrderIdListStr = (String)request.getContext().get((Object)lineToMerge);
                for (String saleOrderId : saleOrderIdListStr.split(",")) {
                    saleOrderIdList.add(new Long(saleOrderId));
                }
                fromPopup = true;
            }
        }
        Currency commonCurrency = null;
        Partner commonClientPartner = null;
        Company commonCompany = null;
        Partner commonContactPartner = null;
        Team commonTeam = null;
        boolean existTeamDiff = false;
        boolean existContactPartnerDiff = false;
        PriceList commonPriceList = null;
        boolean existPriceListDiff = false;
        int count = 1;
        for (Long saleOrderId : saleOrderIdList) {
            SaleOrder saleOrderTemp = (SaleOrder)((Object)JPA.em().find(SaleOrder.class, (Object)saleOrderId));
            saleOrderList.add(saleOrderTemp);
            if (count == 1) {
                commonCurrency = saleOrderTemp.getCurrency();
                commonClientPartner = saleOrderTemp.getClientPartner();
                commonCompany = saleOrderTemp.getCompany();
                commonContactPartner = saleOrderTemp.getContactPartner();
                commonTeam = saleOrderTemp.getTeam();
                commonPriceList = saleOrderTemp.getPriceList();
            } else {
                if (commonCurrency != null && !commonCurrency.equals((Object)saleOrderTemp.getCurrency())) {
                    commonCurrency = null;
                }
                if (commonClientPartner != null && !commonClientPartner.equals((Object)saleOrderTemp.getClientPartner())) {
                    commonClientPartner = null;
                }
                if (commonCompany != null && !commonCompany.equals((Object)saleOrderTemp.getCompany())) {
                    commonCompany = null;
                }
                if (commonContactPartner != null && !commonContactPartner.equals((Object)saleOrderTemp.getContactPartner())) {
                    commonContactPartner = null;
                    existContactPartnerDiff = true;
                }
                if (commonTeam != null && !commonTeam.equals((Object)saleOrderTemp.getTeam())) {
                    commonTeam = null;
                    existTeamDiff = true;
                }
                if (commonPriceList != null && !commonPriceList.equals((Object)saleOrderTemp.getPriceList())) {
                    commonPriceList = null;
                    existPriceListDiff = true;
                }
            }
            ++count;
        }
        StringBuilder fieldErrors = new StringBuilder();
        if (commonCurrency == null) {
            fieldErrors.append(I18n.get((String)"The currency is required and must be the same for all sale orders"));
        }
        if (commonClientPartner == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The client Partner is required and must be the same for all sale orders"));
        }
        if (commonCompany == null) {
            if (fieldErrors.length() > 0) {
                fieldErrors.append("<br/>");
            }
            fieldErrors.append(I18n.get((String)"The company is required and must be the same for all sale orders"));
        }
        if (fieldErrors.length() > 0) {
            response.setFlash(fieldErrors.toString());
            return;
        }
        if (request.getContext().get((Object)"priceList") != null) {
            commonPriceList = (PriceList)JPA.em().find(PriceList.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"priceList")).get("id")).intValue()));
        }
        if (request.getContext().get((Object)"contactPartner") != null) {
            commonContactPartner = (Partner)((Object)JPA.em().find(Partner.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"contactPartner")).get("id")).intValue())));
        }
        if (request.getContext().get((Object)"team") != null) {
            commonTeam = (Team)((Object)JPA.em().find(Team.class, (Object)new Long(((Integer)((Map)request.getContext().get((Object)"team")).get("id")).intValue())));
        }
        if (!fromPopup && (existContactPartnerDiff || existPriceListDiff || existTeamDiff)) {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Confirm merge sale order").model(Wizard.class.getName()).add("form", "sale-order-merge-confirm-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true");
            if (existPriceListDiff) {
                confirmView.context("contextPriceListToCheck", (Object)"true");
            }
            if (existContactPartnerDiff) {
                confirmView.context("contextContactPartnerToCheck", (Object)"true");
                confirmView.context("contextPartnerId", (Object)commonClientPartner.getId().toString());
            }
            if (existTeamDiff) {
                confirmView.context("contextTeamToCheck", (Object)"true");
            }
            confirmView.context(lineToMerge, (Object)Joiner.on((String)",").join(saleOrderIdList));
            response.setView(confirmView.map());
            return;
        }
        try {
            SaleOrder saleOrder = ((SaleOrderCreateService)Beans.get(SaleOrderCreateService.class)).mergeSaleOrders(saleOrderList, commonCurrency, commonClientPartner, commonCompany, commonContactPartner, commonPriceList, commonTeam);
            if (saleOrder != null) {
                response.setView(ActionView.define((String)"Sale order").model(SaleOrder.class.getName()).add("grid", "sale-order-grid").add("form", "sale-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(saleOrder.getId())).map());
                response.setCanClose(true);
            }
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void computeAddressStr(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        ((SaleOrderService)Beans.get(SaleOrderService.class)).computeAddressStr(saleOrder);
        response.setValues((Object)saleOrder);
    }

    public void fillCompanyBankDetails(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        PaymentMode paymentMode = (PaymentMode)request.getContext().get((Object)"paymentMode");
        Company company = saleOrder.getCompany();
        Partner partner = saleOrder.getClientPartner();
        if (company == null) {
            return;
        }
        if (partner != null) {
            partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        }
        BankDetails defaultBankDetails = ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(company, paymentMode, partner, null);
        response.setValue("companyBankDetails", (Object)defaultBankDetails);
    }

    public void enableEditOrder(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(((SaleOrder)((Object)request.getContext().asType(SaleOrder.class))).getId()));
        try {
            boolean checkAvailabiltyRequest = ((SaleOrderService)Beans.get(SaleOrderService.class)).enableEditOrder(saleOrder);
            response.setReload(true);
            if (checkAvailabiltyRequest) {
                response.setNotify(I18n.get((String)"At least one sale order line has a stock move with availability request."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateChanges(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrderView = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrderView.getId()));
            ((SaleOrderService)Beans.get(SaleOrderService.class)).validateChanges(saleOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void filterPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            List printingSettingsList = ((TradingNameService)Beans.get(TradingNameService.class)).getPrintingSettingsList(saleOrder.getTradingName(), saleOrder.getCompany());
            String domain = String.format("self.id IN (%s)", !printingSettingsList.isEmpty() ? StringTool.getIdListString((Collection)printingSettingsList) : "0");
            response.setAttr("printingSettings", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillDefaultPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            response.setValue("printingSettings", (Object)((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(saleOrder.getTradingName(), saleOrder.getCompany()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillPriceList(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder;
        if (request.getContext().get((Object)"_saleOrderTemplate") != null) {
            LinkedHashMap saleOrderTemplateContext = (LinkedHashMap)request.getContext().get((Object)"_saleOrderTemplate");
            Integer saleOrderId = (Integer)saleOrderTemplateContext.get("id");
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find((long)saleOrderId));
        } else {
            saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        }
        response.setValue("priceList", saleOrder.getClientPartner() != null ? ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(saleOrder.getClientPartner(), 1) : null);
    }

    public void changePriceListDomain(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder;
        if (request.getContext().get((Object)"_saleOrderTemplate") != null) {
            LinkedHashMap saleOrderTemplateContext = (LinkedHashMap)request.getContext().get((Object)"_saleOrderTemplate");
            Integer saleOrderId = (Integer)saleOrderTemplateContext.get("id");
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find((long)saleOrderId));
        } else {
            saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        }
        String domain = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getPriceListDomain(saleOrder.getClientPartner(), 1);
        response.setAttr("priceList", "domain", (Object)domain);
    }

    public void removeSubLines(ActionRequest request, ActionResponse response) {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            response.setValue("saleOrderLineList", ((SaleOrderComputeService)Beans.get(SaleOrderComputeService.class)).removeSubLines(saleOrder.getSaleOrderLineList()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void updateSaleOrderLineTax(ActionRequest request, ActionResponse response) throws AxelorException {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        ((SaleOrderCreateService)Beans.get(SaleOrderCreateService.class)).updateSaleOrderLineList(saleOrder);
        response.setValue("saleOrderLineList", saleOrder.getSaleOrderLineList());
    }

    public void getSaleOrderPartnerDomain(ActionRequest request, ActionResponse response) {
        SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
        Company company = saleOrder.getCompany();
        long companyId = company.getPartner().getId();
        String domain = String.format("self.id != %d AND self.isContact = false AND (self.isCustomer = true or self.isProspect = true)", companyId);
        domain = domain + " AND :company member of self.companySet";
        try {
            if (saleOrder.getSaleOrderLineList() != null && !saleOrder.getSaleOrderLineList().isEmpty()) {
                domain = domain + ((PartnerService)Beans.get(PartnerService.class)).getPartnerDomain(saleOrder.getClientPartner());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            response.setError(e.getMessage());
        }
        response.setAttr("clientPartner", "domain", (Object)domain);
    }
}

