/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.helpdesk.db;

import com.axelor.apps.helpdesk.db.TicketType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HELPDESK_SLA", indexes={@Index(columnList="name"), @Index(columnList="team"), @Index(columnList="ticket_type")})
public class Sla
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HELPDESK_SLA_SEQ")
    @SequenceGenerator(name="HELPDESK_SLA_SEQ", sequenceName="HELPDESK_SLA_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="SLA policy name")
    @NotNull
    private String name;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Minimum priority", selection="helpdesk.priority.select")
    private Integer prioritySelect = 2;
    @Widget(title="Ticket type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TicketType ticketType;
    @Widget(title="Reach stage", selection="helpdesk.status.select")
    private Integer reachStageSelect = 0;
    @Widget(title="days")
    @Min(value=0L)
    private Integer days = 0;
    @Widget(title="hours")
    @Min(value=0L)
    private Integer hours = 0;
    @Widget(title="Working Days")
    private Boolean isWorkingDays = Boolean.FALSE;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Sla() {
    }

    public Sla(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Integer getPrioritySelect() {
        return this.prioritySelect == null ? 0 : this.prioritySelect;
    }

    public void setPrioritySelect(Integer prioritySelect) {
        this.prioritySelect = prioritySelect;
    }

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public Integer getReachStageSelect() {
        return this.reachStageSelect == null ? 0 : this.reachStageSelect;
    }

    public void setReachStageSelect(Integer reachStageSelect) {
        this.reachStageSelect = reachStageSelect;
    }

    public Integer getDays() {
        return this.days == null ? 0 : this.days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public Integer getHours() {
        return this.hours == null ? 0 : this.hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public Boolean getIsWorkingDays() {
        return this.isWorkingDays == null ? Boolean.FALSE : this.isWorkingDays;
    }

    public void setIsWorkingDays(Boolean isWorkingDays) {
        this.isWorkingDays = isWorkingDays;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sla)) {
            return false;
        }
        Sla other = (Sla)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("prioritySelect", (Object)this.getPrioritySelect()).add("reachStageSelect", (Object)this.getReachStageSelect()).add("days", (Object)this.getDays()).add("hours", (Object)this.getHours()).add("isWorkingDays", (Object)this.getIsWorkingDays()).omitNullValues().toString();
    }
}

