/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.helpdesk.service;

import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.db.TimerHistory;
import com.axelor.apps.base.db.repo.TimerHistoryRepository;
import com.axelor.apps.base.db.repo.TimerRepository;
import com.axelor.apps.base.service.timer.AbstractTimerService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.helpdesk.db.Ticket;
import com.axelor.apps.helpdesk.db.repo.TicketRepository;
import com.axelor.apps.helpdesk.service.TimerTicketService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

public class TimerTicketServiceImpl
extends AbstractTimerService
implements TimerTicketService {
    protected TicketRepository repository;

    @Inject
    public TimerTicketServiceImpl(TimerRepository timerRepository, TimerHistoryRepository timerHistoryRepository, UserService userService, TicketRepository repository) {
        super(timerRepository, timerHistoryRepository, userService);
        this.repository = repository;
    }

    public Timer find(Model model) throws AxelorException {
        User user = this.userService.getUser();
        Ticket ticket = (Ticket)((Object)model);
        List<Timer> timerList = ticket.getTimerList();
        if (timerList != null && !timerList.isEmpty()) {
            return timerList.stream().filter(t -> t.getAssignedToUser() == user).findFirst().orElse(null);
        }
        return null;
    }

    @Transactional(rollbackOn={Exception.class})
    public TimerHistory start(Model model, Timer timer, LocalDateTime dateTime) throws AxelorException {
        Ticket ticket = (Ticket)((Object)model);
        boolean isNewTimer = timer == null;
        timer = this.tryStartOrCreate(timer);
        if (isNewTimer) {
            ticket.addTimerListItem(timer);
        }
        TimerHistory history = new TimerHistory();
        history.setStartDateT(dateTime);
        history.setTimer(timer);
        timer.addTimerHistoryListItem(history);
        return (TimerHistory)this.timerHistoryRepository.save((Model)history);
    }

    @Override
    public Timer find(Ticket ticket) throws AxelorException {
        return this.find((Model)((Object)ticket));
    }

    @Override
    public TimerHistory start(Ticket task, LocalDateTime dateTime) throws AxelorException {
        Timer timer = this.find(task);
        return this.start((Model)((Object)task), timer, dateTime);
    }

    @Override
    public TimerHistory stop(Ticket task, LocalDateTime dateTime) throws AxelorException {
        Timer timer = this.find(task);
        if (timer != null) {
            return this.stop((Model)((Object)task), timer, dateTime);
        }
        return null;
    }

    @Override
    public void cancel(Ticket task) throws AxelorException {
        Timer timer = this.find(task);
        this.cancel(timer);
    }

    @Override
    public Duration compute(Ticket task) {
        Duration total = Duration.ZERO;
        if (task != null && (task = (Ticket)((Object)this.repository.find(task.getId()))).getTimerList() != null && !task.getTimerList().isEmpty()) {
            for (Timer timer : task.getTimerList()) {
                total = total.plus(this.compute(timer));
            }
        }
        return total;
    }
}

