/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.project.db.GenProjTypePerOrderLine;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.apps.project.db.ResourceBooking;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.db.Wiki;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.axelor.team.db.TeamTask;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_PROJECT", indexes={@Index(columnList="name"), @Index(columnList="team"), @Index(columnList="assigned_to"), @Index(columnList="parent_project"), @Index(columnList="client_partner"), @Index(columnList="contact_partner"), @Index(columnList="company"), @Index(columnList="fullName")})
public class Project
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_SEQ", sequenceName="PROJECT_PROJECT_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @Widget(multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Project Folders")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProjectFolder> projectFolderSet;
    @Widget(title="Child Projects")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentProject", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Project> childProjectList;
    @Widget(title="Assigned to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User assignedTo;
    @Widget(title="Status", selection="project.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Type of authorized categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TeamTaskCategory> teamTaskCategorySet;
    @Widget(title="Tasks")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TeamTask> teamTaskList;
    private Boolean synchronize = Boolean.FALSE;
    private Boolean extendsMembersFromParent = Boolean.FALSE;
    @Widget(title="Parent project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project parentProject;
    @Widget(title="Wiki")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Wiki> wikiList;
    @Widget(title="Resource booking")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ResourceBooking> resourceBookingList;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Membres")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<User> membersUserSet;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Customer Contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="From Date")
    private LocalDateTime fromDate;
    @Widget(title="To Date")
    private LocalDateTime toDate;
    @Widget(title="Due Date")
    private LocalDateTime dueDate;
    @Widget(title="Estimated time (in days)")
    private BigDecimal estimatedTimeDays = BigDecimal.ZERO;
    @Widget(title="Estimated time (in hours)")
    private BigDecimal estimatedTimeHrs = BigDecimal.ZERO;
    @Widget(title="Time Spent")
    private BigDecimal timeSpent = BigDecimal.ZERO;
    @Widget(title="Progress (%)")
    private BigDecimal progress = BigDecimal.ZERO;
    @Widget(title="Sequence")
    private BigDecimal sequence = BigDecimal.ZERO;
    private Integer orderByState = 0;
    @Widget(massUpdate=true)
    private Boolean imputable = Boolean.TRUE;
    @Widget(title="Finish tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> finishToStartTaskSet;
    @Widget(title="Start tasks to start")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> startToStartTaskSet;
    @Widget(title="Finish tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> finishToFinishTaskSet;
    @Widget(title="Start tasks to finish")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> startToFinishTaskSet;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Type of authorized activities")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Exclude planning")
    private Boolean excludePlanning = Boolean.FALSE;
    @Widget(title="Name")
    @NameColumn
    private String fullName;
    @Widget(title="Project/Phase")
    private Boolean isProject = Boolean.TRUE;
    @Widget(title="Show phases elements")
    private Boolean isShowPhasesElements = Boolean.TRUE;
    @Widget(selection="project.project.project.type.select")
    private Integer projectTypeSelect = 1;
    @Basic
    @Type(type="com.axelor.db.hibernate.type.ValueEnumType")
    private GenProjTypePerOrderLine genProjTypePerOrderLine = GenProjTypePerOrderLine.BUSINESS_PROJECT;
    @Widget(title="Logged Time")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<TimesheetLine> timesheetLineList;
    @Widget(title="Total planned hours")
    private BigDecimal totalPlannedHrs = BigDecimal.ZERO;
    @Widget(title="Total real hours")
    private BigDecimal totalRealHrs = BigDecimal.ZERO;
    @Widget(title="Exclude timesheet editor")
    private Boolean excludeTimesheetEditor = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Project() {
    }

    public Project(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Set<ProjectFolder> getProjectFolderSet() {
        return this.projectFolderSet;
    }

    public void setProjectFolderSet(Set<ProjectFolder> projectFolderSet) {
        this.projectFolderSet = projectFolderSet;
    }

    public void addProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            this.setProjectFolderSet(new HashSet<ProjectFolder>());
        }
        this.getProjectFolderSet().add(item);
    }

    public void removeProjectFolderSetItem(ProjectFolder item) {
        if (this.getProjectFolderSet() == null) {
            return;
        }
        this.getProjectFolderSet().remove(item);
    }

    public void clearProjectFolderSet() {
        if (this.getProjectFolderSet() != null) {
            this.getProjectFolderSet().clear();
        }
    }

    public List<Project> getChildProjectList() {
        return this.childProjectList;
    }

    public void setChildProjectList(List<Project> childProjectList) {
        this.childProjectList = childProjectList;
    }

    public void addChildProjectListItem(Project item) {
        if (this.getChildProjectList() == null) {
            this.setChildProjectList(new ArrayList<Project>());
        }
        this.getChildProjectList().add(item);
        item.setParentProject(this);
    }

    public void removeChildProjectListItem(Project item) {
        if (this.getChildProjectList() == null) {
            return;
        }
        this.getChildProjectList().remove((Object)item);
    }

    public void clearChildProjectList() {
        if (this.getChildProjectList() != null) {
            this.getChildProjectList().clear();
        }
    }

    public User getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(User assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Set<TeamTaskCategory> getTeamTaskCategorySet() {
        return this.teamTaskCategorySet;
    }

    public void setTeamTaskCategorySet(Set<TeamTaskCategory> teamTaskCategorySet) {
        this.teamTaskCategorySet = teamTaskCategorySet;
    }

    public void addTeamTaskCategorySetItem(TeamTaskCategory item) {
        if (this.getTeamTaskCategorySet() == null) {
            this.setTeamTaskCategorySet(new HashSet<TeamTaskCategory>());
        }
        this.getTeamTaskCategorySet().add(item);
    }

    public void removeTeamTaskCategorySetItem(TeamTaskCategory item) {
        if (this.getTeamTaskCategorySet() == null) {
            return;
        }
        this.getTeamTaskCategorySet().remove(item);
    }

    public void clearTeamTaskCategorySet() {
        if (this.getTeamTaskCategorySet() != null) {
            this.getTeamTaskCategorySet().clear();
        }
    }

    public List<TeamTask> getTeamTaskList() {
        return this.teamTaskList;
    }

    public void setTeamTaskList(List<TeamTask> teamTaskList) {
        this.teamTaskList = teamTaskList;
    }

    public void addTeamTaskListItem(TeamTask item) {
        if (this.getTeamTaskList() == null) {
            this.setTeamTaskList(new ArrayList<TeamTask>());
        }
        this.getTeamTaskList().add(item);
        item.setProject(this);
    }

    public void removeTeamTaskListItem(TeamTask item) {
        if (this.getTeamTaskList() == null) {
            return;
        }
        this.getTeamTaskList().remove((Object)item);
    }

    public void clearTeamTaskList() {
        if (this.getTeamTaskList() != null) {
            this.getTeamTaskList().clear();
        }
    }

    public Boolean getSynchronize() {
        return this.synchronize == null ? Boolean.FALSE : this.synchronize;
    }

    public void setSynchronize(Boolean synchronize) {
        this.synchronize = synchronize;
    }

    public Boolean getExtendsMembersFromParent() {
        return this.extendsMembersFromParent == null ? Boolean.FALSE : this.extendsMembersFromParent;
    }

    public void setExtendsMembersFromParent(Boolean extendsMembersFromParent) {
        this.extendsMembersFromParent = extendsMembersFromParent;
    }

    public Project getParentProject() {
        return this.parentProject;
    }

    public void setParentProject(Project parentProject) {
        this.parentProject = parentProject;
    }

    public List<Wiki> getWikiList() {
        return this.wikiList;
    }

    public void setWikiList(List<Wiki> wikiList) {
        this.wikiList = wikiList;
    }

    public void addWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            this.setWikiList(new ArrayList<Wiki>());
        }
        this.getWikiList().add(item);
        item.setProject(this);
    }

    public void removeWikiListItem(Wiki item) {
        if (this.getWikiList() == null) {
            return;
        }
        this.getWikiList().remove(item);
    }

    public void clearWikiList() {
        if (this.getWikiList() != null) {
            this.getWikiList().clear();
        }
    }

    public List<ResourceBooking> getResourceBookingList() {
        return this.resourceBookingList;
    }

    public void setResourceBookingList(List<ResourceBooking> resourceBookingList) {
        this.resourceBookingList = resourceBookingList;
    }

    public void addResourceBookingListItem(ResourceBooking item) {
        if (this.getResourceBookingList() == null) {
            this.setResourceBookingList(new ArrayList<ResourceBooking>());
        }
        this.getResourceBookingList().add(item);
        item.setProject(this);
    }

    public void removeResourceBookingListItem(ResourceBooking item) {
        if (this.getResourceBookingList() == null) {
            return;
        }
        this.getResourceBookingList().remove(item);
    }

    public void clearResourceBookingList() {
        if (this.getResourceBookingList() != null) {
            this.getResourceBookingList().clear();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<User> getMembersUserSet() {
        return this.membersUserSet;
    }

    public void setMembersUserSet(Set<User> membersUserSet) {
        this.membersUserSet = membersUserSet;
    }

    public void addMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            this.setMembersUserSet(new HashSet<User>());
        }
        this.getMembersUserSet().add(item);
    }

    public void removeMembersUserSetItem(User item) {
        if (this.getMembersUserSet() == null) {
            return;
        }
        this.getMembersUserSet().remove((Object)item);
    }

    public void clearMembersUserSet() {
        if (this.getMembersUserSet() != null) {
            this.getMembersUserSet().clear();
        }
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public BigDecimal getEstimatedTimeDays() {
        return this.estimatedTimeDays == null ? BigDecimal.ZERO : this.estimatedTimeDays;
    }

    public void setEstimatedTimeDays(BigDecimal estimatedTimeDays) {
        this.estimatedTimeDays = estimatedTimeDays;
    }

    public BigDecimal getEstimatedTimeHrs() {
        return this.estimatedTimeHrs == null ? BigDecimal.ZERO : this.estimatedTimeHrs;
    }

    public void setEstimatedTimeHrs(BigDecimal estimatedTimeHrs) {
        this.estimatedTimeHrs = estimatedTimeHrs;
    }

    public BigDecimal getTimeSpent() {
        return this.timeSpent == null ? BigDecimal.ZERO : this.timeSpent;
    }

    public void setTimeSpent(BigDecimal timeSpent) {
        this.timeSpent = timeSpent;
    }

    public BigDecimal getProgress() {
        return this.progress == null ? BigDecimal.ZERO : this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public BigDecimal getSequence() {
        return this.sequence == null ? BigDecimal.ZERO : this.sequence;
    }

    public void setSequence(BigDecimal sequence) {
        this.sequence = sequence;
    }

    public Integer getOrderByState() {
        return this.orderByState == null ? 0 : this.orderByState;
    }

    public void setOrderByState(Integer orderByState) {
        this.orderByState = orderByState;
    }

    public Boolean getImputable() {
        return this.imputable == null ? Boolean.FALSE : this.imputable;
    }

    public void setImputable(Boolean imputable) {
        this.imputable = imputable;
    }

    public Set<Project> getFinishToStartTaskSet() {
        return this.finishToStartTaskSet;
    }

    public void setFinishToStartTaskSet(Set<Project> finishToStartTaskSet) {
        this.finishToStartTaskSet = finishToStartTaskSet;
    }

    public void addFinishToStartTaskSetItem(Project item) {
        if (this.getFinishToStartTaskSet() == null) {
            this.setFinishToStartTaskSet(new HashSet<Project>());
        }
        this.getFinishToStartTaskSet().add(item);
    }

    public void removeFinishToStartTaskSetItem(Project item) {
        if (this.getFinishToStartTaskSet() == null) {
            return;
        }
        this.getFinishToStartTaskSet().remove((Object)item);
    }

    public void clearFinishToStartTaskSet() {
        if (this.getFinishToStartTaskSet() != null) {
            this.getFinishToStartTaskSet().clear();
        }
    }

    public Set<Project> getStartToStartTaskSet() {
        return this.startToStartTaskSet;
    }

    public void setStartToStartTaskSet(Set<Project> startToStartTaskSet) {
        this.startToStartTaskSet = startToStartTaskSet;
    }

    public void addStartToStartTaskSetItem(Project item) {
        if (this.getStartToStartTaskSet() == null) {
            this.setStartToStartTaskSet(new HashSet<Project>());
        }
        this.getStartToStartTaskSet().add(item);
    }

    public void removeStartToStartTaskSetItem(Project item) {
        if (this.getStartToStartTaskSet() == null) {
            return;
        }
        this.getStartToStartTaskSet().remove((Object)item);
    }

    public void clearStartToStartTaskSet() {
        if (this.getStartToStartTaskSet() != null) {
            this.getStartToStartTaskSet().clear();
        }
    }

    public Set<Project> getFinishToFinishTaskSet() {
        return this.finishToFinishTaskSet;
    }

    public void setFinishToFinishTaskSet(Set<Project> finishToFinishTaskSet) {
        this.finishToFinishTaskSet = finishToFinishTaskSet;
    }

    public void addFinishToFinishTaskSetItem(Project item) {
        if (this.getFinishToFinishTaskSet() == null) {
            this.setFinishToFinishTaskSet(new HashSet<Project>());
        }
        this.getFinishToFinishTaskSet().add(item);
    }

    public void removeFinishToFinishTaskSetItem(Project item) {
        if (this.getFinishToFinishTaskSet() == null) {
            return;
        }
        this.getFinishToFinishTaskSet().remove((Object)item);
    }

    public void clearFinishToFinishTaskSet() {
        if (this.getFinishToFinishTaskSet() != null) {
            this.getFinishToFinishTaskSet().clear();
        }
    }

    public Set<Project> getStartToFinishTaskSet() {
        return this.startToFinishTaskSet;
    }

    public void setStartToFinishTaskSet(Set<Project> startToFinishTaskSet) {
        this.startToFinishTaskSet = startToFinishTaskSet;
    }

    public void addStartToFinishTaskSetItem(Project item) {
        if (this.getStartToFinishTaskSet() == null) {
            this.setStartToFinishTaskSet(new HashSet<Project>());
        }
        this.getStartToFinishTaskSet().add(item);
    }

    public void removeStartToFinishTaskSetItem(Project item) {
        if (this.getStartToFinishTaskSet() == null) {
            return;
        }
        this.getStartToFinishTaskSet().remove((Object)item);
    }

    public void clearStartToFinishTaskSet() {
        if (this.getStartToFinishTaskSet() != null) {
            this.getStartToFinishTaskSet().clear();
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Boolean getExcludePlanning() {
        return this.excludePlanning == null ? Boolean.FALSE : this.excludePlanning;
    }

    public void setExcludePlanning(Boolean excludePlanning) {
        this.excludePlanning = excludePlanning;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Boolean getIsProject() {
        return this.isProject == null ? Boolean.FALSE : this.isProject;
    }

    public void setIsProject(Boolean isProject) {
        this.isProject = isProject;
    }

    public Boolean getIsShowPhasesElements() {
        return this.isShowPhasesElements == null ? Boolean.FALSE : this.isShowPhasesElements;
    }

    public void setIsShowPhasesElements(Boolean isShowPhasesElements) {
        this.isShowPhasesElements = isShowPhasesElements;
    }

    public Integer getProjectTypeSelect() {
        return this.projectTypeSelect == null ? 0 : this.projectTypeSelect;
    }

    public void setProjectTypeSelect(Integer projectTypeSelect) {
        this.projectTypeSelect = projectTypeSelect;
    }

    public GenProjTypePerOrderLine getGenProjTypePerOrderLine() {
        return this.genProjTypePerOrderLine;
    }

    public void setGenProjTypePerOrderLine(GenProjTypePerOrderLine genProjTypePerOrderLine) {
        this.genProjTypePerOrderLine = genProjTypePerOrderLine;
    }

    public List<TimesheetLine> getTimesheetLineList() {
        return this.timesheetLineList;
    }

    public void setTimesheetLineList(List<TimesheetLine> timesheetLineList) {
        this.timesheetLineList = timesheetLineList;
    }

    public void addTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            this.setTimesheetLineList(new ArrayList<TimesheetLine>());
        }
        this.getTimesheetLineList().add(item);
        item.setProject(this);
    }

    public void removeTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            return;
        }
        this.getTimesheetLineList().remove(item);
        item.setProject(null);
    }

    public void clearTimesheetLineList() {
        if (this.getTimesheetLineList() != null) {
            for (TimesheetLine item : this.getTimesheetLineList()) {
                item.setProject(null);
            }
            this.getTimesheetLineList().clear();
        }
    }

    public BigDecimal getTotalPlannedHrs() {
        return this.totalPlannedHrs == null ? BigDecimal.ZERO : this.totalPlannedHrs;
    }

    public void setTotalPlannedHrs(BigDecimal totalPlannedHrs) {
        this.totalPlannedHrs = totalPlannedHrs;
    }

    public BigDecimal getTotalRealHrs() {
        return this.totalRealHrs == null ? BigDecimal.ZERO : this.totalRealHrs;
    }

    public void setTotalRealHrs(BigDecimal totalRealHrs) {
        this.totalRealHrs = totalRealHrs;
    }

    public Boolean getExcludeTimesheetEditor() {
        return this.excludeTimesheetEditor == null ? Boolean.FALSE : this.excludeTimesheetEditor;
    }

    public void setExcludeTimesheetEditor(Boolean excludeTimesheetEditor) {
        this.excludeTimesheetEditor = excludeTimesheetEditor;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1355342585, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("synchronize", (Object)this.getSynchronize()).add("extendsMembersFromParent", (Object)this.getExtendsMembersFromParent()).add("code", (Object)this.getCode()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("dueDate", (Object)this.getDueDate()).add("estimatedTimeDays", (Object)this.getEstimatedTimeDays()).add("estimatedTimeHrs", (Object)this.getEstimatedTimeHrs()).add("timeSpent", (Object)this.getTimeSpent()).omitNullValues().toString();
    }
}

