/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.base.db.ICalendar;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.talent.db.Training;
import com.axelor.apps.talent.db.TrainingSession;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_TRAINING_REGISTER", indexes={@Index(columnList="training_session"), @Index(columnList="training"), @Index(columnList="employee"), @Index(columnList="calendar"), @Index(columnList="fullName")})
public class TrainingRegister
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_TRAINING_REGISTER_SEQ")
    @SequenceGenerator(name="TALENT_TRAINING_REGISTER_SEQ", sequenceName="TALENT_TRAINING_REGISTER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Session")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrainingSession trainingSession;
    @Widget(title="Training")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Training training;
    @Widget(title="Employee")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="From date")
    @NotNull
    private LocalDateTime fromDate;
    @Widget(title="To date")
    @NotNull
    private LocalDateTime toDate;
    @Widget(title="Rating", selection="training.register.rating.select")
    private Integer ratingSelect = 0;
    @Widget(title="Status", selection="training.register.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Calendar")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendar calendar;
    @NameColumn
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TrainingSession getTrainingSession() {
        return this.trainingSession;
    }

    public void setTrainingSession(TrainingSession trainingSession) {
        this.trainingSession = trainingSession;
    }

    public Training getTraining() {
        return this.training;
    }

    public void setTraining(Training training) {
        this.training = training;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public Integer getRatingSelect() {
        return this.ratingSelect == null ? 0 : this.ratingSelect;
    }

    public void setRatingSelect(Integer ratingSelect) {
        this.ratingSelect = ratingSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public ICalendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(ICalendar calendar) {
        this.calendar = calendar;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrainingRegister)) {
            return false;
        }
        TrainingRegister other = (TrainingRegister)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("ratingSelect", (Object)this.getRatingSelect()).add("statusSelect", (Object)this.getStatusSelect()).add("fullName", (Object)this.getFullName()).omitNullValues().toString();
    }
}

