/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db.repo;

import com.axelor.apps.talent.db.Training;
import com.axelor.apps.talent.db.TrainingRegister;
import com.axelor.apps.talent.db.TrainingSession;
import com.axelor.apps.talent.db.repo.TrainingRegisterRepository;
import com.axelor.apps.talent.service.TrainingRegisterService;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import javax.validation.ValidationException;

public class TrainingRegisterTalentRepository
extends TrainingRegisterRepository {
    @Inject
    private TrainingRegisterService trainingRegisterService;

    public TrainingRegister save(TrainingRegister trainingRegister) {
        if (trainingRegister.getFromDate().isAfter(trainingRegister.getToDate())) {
            throw new ValidationException(I18n.get((String)"Invalid dates. From date must be before to date."));
        }
        TrainingSession trainingSession = trainingRegister.getTrainingSession();
        if (trainingSession != null && (trainingSession.getFromDate().isAfter(trainingRegister.getFromDate()) || trainingSession.getToDate().isBefore(trainingRegister.getToDate()))) {
            throw new ValidationException(I18n.get((String)"Training dates must be under training session date range."));
        }
        trainingRegister.setFullName(this.trainingRegisterService.computeFullName(trainingRegister));
        trainingRegister = (TrainingRegister)((Object)super.save((Model)((Object)trainingRegister)));
        this.trainingRegisterService.updateTrainingRating(trainingRegister.getTraining(), null);
        if (trainingRegister.getTrainingSession() != null) {
            this.trainingRegisterService.updateSessionRating(trainingRegister.getTrainingSession(), null);
        }
        this.refresh((Model)((Object)trainingRegister));
        return trainingRegister;
    }

    public void remove(TrainingRegister trainingRegister) {
        Training training = trainingRegister.getTraining();
        TrainingSession session = trainingRegister.getTrainingSession();
        super.remove((Model)((Object)trainingRegister));
        this.trainingRegisterService.updateTrainingRating(training, null);
        if (session != null) {
            this.trainingRegisterService.updateSessionRating(session, null);
        }
    }
}

