/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.service;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.talent.db.Appraisal;
import com.axelor.apps.talent.db.repo.AppraisalRepository;
import com.axelor.apps.talent.service.AppraisalService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.mail.MessagingException;

public class AppraisalServiceImpl
implements AppraisalService {
    @Inject
    private AppraisalRepository appraisalRepo;
    @Inject
    private MailFollowerRepository mailFollowerRepo;
    @Inject
    private TemplateRepository templateRepo;
    @Inject
    private TemplateMessageService templateMessageService;
    @Inject
    private MessageService messageService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void send(Appraisal appraisal) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException, MessagingException {
        Employee employee = appraisal.getEmployee();
        User user = employee.getUser();
        if (user != null) {
            this.mailFollowerRepo.follow((Model)((Object)appraisal), user);
        }
        Template template = (Template)((Object)this.templateRepo.all().filter("self.metaModel.fullName = ?1", new Object[]{Appraisal.class.getName()}).fetchOne());
        EmailAddress email = null;
        if (employee.getContactPartner() != null) {
            email = employee.getContactPartner().getEmailAddress();
        }
        if (template != null && email != null) {
            Message message = this.templateMessageService.generateMessage((Model)((Object)appraisal), template);
            message.addToEmailAddressSetItem(email);
            this.messageService.sendByEmail(message);
        }
        appraisal.setStatusSelect(1);
        this.appraisalRepo.save((Model)((Object)appraisal));
    }

    @Override
    @Transactional
    public void realize(Appraisal appraisal) {
        appraisal.setStatusSelect(2);
        this.appraisalRepo.save((Model)((Object)appraisal));
    }

    @Override
    @Transactional
    public void cancel(Appraisal appraisal) {
        appraisal.setStatusSelect(3);
        this.appraisalRepo.save((Model)((Object)appraisal));
    }

    @Override
    @Transactional
    public void draft(Appraisal appraisal) {
        appraisal.setStatusSelect(0);
        this.appraisalRepo.save((Model)((Object)appraisal));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Set<Long> createAppraisals(Appraisal appraisalTemplate, Set<Employee> employees, Boolean send) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AxelorException, IOException, MessagingException {
        HashSet<Long> appraisalIds = new HashSet<Long>();
        if (appraisalTemplate == null) {
            return appraisalIds;
        }
        for (Employee employee : employees) {
            EmploymentContract employmentContract;
            Appraisal appraisal = (Appraisal)((Object)this.appraisalRepo.copy((Model)((Object)appraisalTemplate), false));
            appraisal.setEmployee(employee);
            if (appraisal.getCompany() == null && (employmentContract = employee.getMainEmploymentContract()) != null) {
                appraisal.setCompany(employmentContract.getPayCompany());
            }
            appraisal.setIsTemplate(false);
            appraisal = (Appraisal)((Object)this.appraisalRepo.save((Model)((Object)appraisal)));
            if (send != null && send.booleanValue()) {
                this.send(appraisal);
            }
            appraisalIds.add(appraisal.getId());
        }
        return appraisalIds;
    }
}

