/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.service;

import com.axelor.apps.base.db.AppRecruitment;
import com.axelor.apps.base.db.repo.AppRecruitmentRepository;
import com.axelor.apps.base.service.message.MailAccountServiceBaseImpl;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.talent.service.JobPositionService;
import com.axelor.mail.MailParser;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Date;
import javax.mail.MessagingException;

public class MailAccountServiceTalentImpl
extends MailAccountServiceBaseImpl {
    @Inject
    private AppRecruitmentRepository appRecruitmentRepo;
    @Inject
    private JobPositionService jobPositionService;

    @Inject
    public MailAccountServiceTalentImpl(UserService userService) {
        super(userService);
    }

    @Transactional(rollbackOn={Exception.class})
    public Message createMessage(EmailAccount mailAccount, MailParser parser, Date date) throws MessagingException {
        String lastEmailId;
        Message message = super.createMessage(mailAccount, parser, date);
        AppRecruitment appRecruitment = (AppRecruitment)((Object)this.appRecruitmentRepo.all().fetchOne());
        if (appRecruitment != null && appRecruitment.getActive().booleanValue() && message.getMailAccount() != null && message.getMailAccount().getServerTypeSelect() > 1 && ((lastEmailId = appRecruitment.getLastEmailId()) == null || message.getId() > Long.parseLong(lastEmailId))) {
            this.jobPositionService.createJobApplication(message);
        }
        return message;
    }
}

