/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.service;

import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.talent.db.Training;
import com.axelor.apps.talent.db.TrainingRegister;
import com.axelor.apps.talent.db.TrainingSession;
import com.axelor.apps.talent.db.repo.TrainingRegisterRepository;
import com.axelor.apps.talent.db.repo.TrainingRepository;
import com.axelor.apps.talent.db.repo.TrainingSessionRepository;
import com.axelor.apps.talent.service.TrainingRegisterService;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingRegisterServiceImpl
implements TrainingRegisterService {
    private final Logger log = LoggerFactory.getLogger(TrainingRegisterService.class);
    @Inject
    protected TrainingRegisterRepository trainingRegisterRepo;
    @Inject
    protected EventRepository eventRepo;
    @Inject
    protected TrainingRepository trainingRepo;
    @Inject
    protected TrainingSessionRepository trainingSessionRepo;
    public static final String RELATED_TO_TRAINING_REGISTER = "com.axelor.apps.talent.db.TrainingRegister";

    @Override
    @Transactional
    public Event plan(TrainingRegister trainingRegister) {
        trainingRegister.setStatusSelect(1);
        this.trainingRegisterRepo.save((Model)((Object)trainingRegister));
        Event event = this.generateMeeting(trainingRegister);
        return (Event)this.eventRepo.save((Model)event);
    }

    protected Event generateMeeting(TrainingRegister trainingRegister) {
        Event event = new Event();
        event.setTypeSelect(Integer.valueOf(2));
        event.setStartDateTime(trainingRegister.getFromDate());
        event.setEndDateTime(trainingRegister.getToDate());
        event.setSubject(trainingRegister.getTraining().getName());
        event.setUser(trainingRegister.getEmployee().getUser());
        event.setCalendar(trainingRegister.getCalendar());
        event.setRelatedToSelect(RELATED_TO_TRAINING_REGISTER);
        event.setRelatedToSelectId(trainingRegister.getId());
        if (trainingRegister.getTrainingSession() != null) {
            event.setLocation(trainingRegister.getTrainingSession().getLocation());
        }
        return event;
    }

    @Override
    @Transactional
    public void complete(TrainingRegister trainingRegister) {
        trainingRegister.setStatusSelect(2);
        trainingRegister.getEmployee().getSkillSet().addAll(trainingRegister.getTraining().getSkillSet());
        this.trainingRegisterRepo.save((Model)((Object)trainingRegister));
    }

    @Override
    @Transactional
    public Training updateTrainingRating(Training training, Long excludeId) {
        String query = "self.training = ?1";
        if (excludeId != null) {
            query = query + " AND self.id != " + excludeId;
        }
        List trainingTrs = this.trainingRegisterRepo.all().filter(query, new Object[]{training}).fetch();
        long totalTrainingsRating = trainingTrs.stream().mapToLong(tr -> tr.getRatingSelect().intValue()).sum();
        int totalTrainingSize = trainingTrs.size();
        this.log.debug("Training: {}", (Object)training.getName());
        this.log.debug("Total trainings TR: {}", (Object)totalTrainingSize);
        this.log.debug("Total ratings:: training: {}", (Object)totalTrainingsRating);
        double avgRating = totalTrainingSize == 0 ? 0.0 : (double)(totalTrainingsRating / (long)totalTrainingSize);
        this.log.debug("Avg training rating : {}", (Object)avgRating);
        training.setRating(new BigDecimal(avgRating));
        return (Training)((Object)this.trainingRepo.save((Model)((Object)training)));
    }

    @Override
    @Transactional
    public TrainingSession updateSessionRating(TrainingSession session, Long excludeId) {
        String query = "self.trainingSession = ?1";
        if (excludeId != null) {
            query = query + " AND self.id != " + excludeId;
        }
        List sessionTrs = this.trainingRegisterRepo.all().filter(query, new Object[]{session}).fetch();
        long totalSessionsRating = sessionTrs.stream().mapToLong(tr -> tr.getRatingSelect().intValue()).sum();
        int totalSessionSize = sessionTrs.size();
        double avgRating = totalSessionSize == 0 ? 0.0 : (double)(totalSessionsRating / (long)totalSessionSize);
        this.log.debug("Avg session rating : {}", (Object)avgRating);
        session.setRating(new BigDecimal(avgRating));
        session.setNbrRegistered(totalSessionSize);
        return (TrainingSession)((Object)this.trainingSessionRepo.save((Model)((Object)session)));
    }

    @Override
    @Transactional
    public void cancel(TrainingRegister trainingRegister) {
        trainingRegister.setStatusSelect(3);
        this.trainingRegisterRepo.save((Model)((Object)trainingRegister));
    }

    @Override
    @Transactional
    public void updateEventCalendar(TrainingRegister trainingRegister) {
        Event event = (Event)this.eventRepo.all().filter("self.relatedToSelect = ?1 AND self.relatedToSelectId = ?2", new Object[]{RELATED_TO_TRAINING_REGISTER, trainingRegister.getId()}).fetchOne();
        if (event != null) {
            event.setCalendar(trainingRegister.getCalendar());
            this.eventRepo.save((Model)event);
        }
    }

    @Override
    public String computeFullName(TrainingRegister trainingRegister) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyyyyHHmm");
        return trainingRegister.getTraining().getName() + "-" + trainingRegister.getEmployee().getName() + "-" + trainingRegister.getFromDate().format(formatter) + "-" + trainingRegister.getToDate().format(formatter);
    }
}

