/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.service;

import com.axelor.apps.talent.db.TrainingRegister;
import com.axelor.apps.talent.db.TrainingSession;
import com.axelor.apps.talent.db.repo.TrainingRegisterRepository;
import com.axelor.apps.talent.db.repo.TrainingSessionRepository;
import com.axelor.apps.talent.service.TrainingRegisterService;
import com.axelor.apps.talent.service.TrainingSessionService;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class TrainingSessionServiceImpl
implements TrainingSessionService {
    @Inject
    private TrainingSessionRepository trainingSessionRepo;
    @Inject
    private TrainingRegisterService trainingRegisterService;
    @Inject
    private TrainingRegisterRepository trainingRegisterRepo;

    @Override
    @Transactional
    public void closeSession(TrainingSession trainingSession) {
        trainingSession.setStatusSelect(2);
        List trainingRegisters = this.trainingRegisterRepo.all().filter("self.trainingSession = ?1", new Object[]{trainingSession}).fetch();
        for (TrainingRegister trainingRegister : trainingRegisters) {
            this.trainingRegisterService.complete(trainingRegister);
        }
        this.trainingSessionRepo.save((Model)((Object)trainingSession));
    }

    @Override
    public String computeFullName(TrainingSession trainingSession) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        return trainingSession.getFromDate().format(formatter) + " - " + trainingSession.getToDate().format(formatter);
    }
}

