/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_SHIPPING_COEF", indexes={@Index(columnList="company"), @Index(columnList="supplier_catalog")})
public class ShippingCoef
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_SHIPPING_COEF_SEQ")
    @SequenceGenerator(name="BASE_SHIPPING_COEF_SEQ", sequenceName="BASE_SHIPPING_COEF_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Shipping Coef.")
    private BigDecimal shippingCoef = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SupplierCatalog supplierCatalog;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getShippingCoef() {
        return this.shippingCoef == null ? BigDecimal.ZERO : this.shippingCoef;
    }

    public void setShippingCoef(BigDecimal shippingCoef) {
        this.shippingCoef = shippingCoef;
    }

    public SupplierCatalog getSupplierCatalog() {
        return this.supplierCatalog;
    }

    public void setSupplierCatalog(SupplierCatalog supplierCatalog) {
        this.supplierCatalog = supplierCatalog;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShippingCoef)) {
            return false;
        }
        ShippingCoef other = (ShippingCoef)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("shippingCoef", (Object)this.getShippingCoef()).omitNullValues().toString();
    }
}

