/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.portal.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.helpdesk.db.repo.TicketRepository;
import com.axelor.apps.portal.service.ClientViewService;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.auth.db.User;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientViewServiceImpl
implements ClientViewService {
    protected SaleOrderRepository saleOrderRepo;
    protected StockMoveRepository stockMoveRepo;
    protected ProjectRepository projectRepo;
    protected TicketRepository ticketRepo;
    protected InvoiceRepository invoiceRepo;
    protected TeamTaskRepository teamTaskRepo;
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    static final String CLIENT_PORTAL_NO_DATE = "None";

    @Inject
    public ClientViewServiceImpl(SaleOrderRepository saleOrderRepo, StockMoveRepository stockMoveRepo, ProjectRepository projectRepo, TicketRepository ticketRepo, InvoiceRepository invoiceRepo, TeamTaskRepository teamTaskRepo) {
        this.saleOrderRepo = saleOrderRepo;
        this.stockMoveRepo = stockMoveRepo;
        this.projectRepo = projectRepo;
        this.ticketRepo = ticketRepo;
        this.invoiceRepo = invoiceRepo;
        this.teamTaskRepo = teamTaskRepo;
    }

    @Override
    public User getClientUser() {
        return ((UserService)Beans.get(UserService.class)).getUser();
    }

    @Override
    public Map<String, Object> updateClientViewIndicators() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.getClientUser();
        map.put("$ordersInProgress", this.getOrdersInProgressIndicator(user));
        map.put("$myQuotation", this.getQuotationsIndicator(user));
        map.put("$lastOrder", this.getLastOrderIndicator(user));
        map.put("$lastDelivery", this.getLastDeliveryIndicator(user));
        map.put("$nextDelivery", this.getNextDeliveryIndicator(user));
        map.put("$plannedDeliveries", this.getPlannedDeliveriesIndicator(user));
        map.put("$myReversions", this.getReversionsIndicator(user));
        map.put("$overdueInvoices", this.getOverdueInvoicesIndicator(user));
        map.put("$awaitingInvoices", this.getAwaitingInvoicesIndicator(user));
        map.put("$totalRemaining", this.getTotalRemainingIndicator(user));
        map.put("$myRefund", this.getRefundIndicator(user));
        map.put("$customerTickets", this.getCustomerTicketsIndicator(user));
        map.put("$companyTickets", this.getCompanyTicketsIndicator(user));
        map.put("$resolvedTickets", this.getResolvedTicketsIndicator(user));
        map.put("$lateTickets", this.getLateTicketsIndicator(user));
        map.put("$totalProjects", this.getTotalProjectsIndicator(user));
        map.put("$newTasks", this.getNewTasksIndicator(user));
        map.put("$tasksInProgress", this.getTasksInProgressIndicator(user));
        map.put("$tasksDue", this.getTasksDueIndicator(user));
        return map;
    }

    protected Integer getOrdersInProgressIndicator(User user) {
        List saleOrderList = this.saleOrderRepo.all().filter(this.getOrdersInProgressOfUser(user)).fetch();
        return !saleOrderList.isEmpty() ? saleOrderList.size() : 0;
    }

    protected Integer getQuotationsIndicator(User user) {
        List saleOrderList = this.saleOrderRepo.all().filter(this.getQuotationsOfUser(user)).fetch();
        return !saleOrderList.isEmpty() ? saleOrderList.size() : 0;
    }

    protected String getLastOrderIndicator(User user) {
        SaleOrder saleOrder = (SaleOrder)((Object)this.saleOrderRepo.all().filter(this.getLastOrderOfUser(user)).fetchOne());
        if (saleOrder == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return saleOrder.getConfirmationDateTime() != null ? saleOrder.getConfirmationDateTime().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected String getLastDeliveryIndicator(User user) {
        StockMove stockMove = (StockMove)((Object)this.stockMoveRepo.all().filter(this.getLastDeliveryOfUser(user)).fetchOne());
        if (stockMove == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return stockMove.getRealDate() != null ? stockMove.getRealDate().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected String getNextDeliveryIndicator(User user) {
        StockMove stockMove = (StockMove)((Object)this.stockMoveRepo.all().filter(this.getNextDeliveryOfUser(user)).fetchOne());
        if (stockMove == null) {
            return I18n.get((String)CLIENT_PORTAL_NO_DATE);
        }
        return stockMove.getEstimatedDate() != null ? stockMove.getEstimatedDate().format(DATE_FORMATTER) : I18n.get((String)CLIENT_PORTAL_NO_DATE);
    }

    protected Integer getPlannedDeliveriesIndicator(User user) {
        List stockMoveList = this.stockMoveRepo.all().filter(this.getPlannedDeliveriesOfUser(user)).fetch();
        return !stockMoveList.isEmpty() ? stockMoveList.size() : 0;
    }

    protected Integer getReversionsIndicator(User user) {
        List stockMoveList = this.stockMoveRepo.all().filter(this.getReversionsOfUser(user)).fetch();
        return !stockMoveList.isEmpty() ? stockMoveList.size() : 0;
    }

    protected Integer getOverdueInvoicesIndicator(User user) {
        List invoiceList = this.invoiceRepo.all().filter(this.getOverdueInvoicesOfUser(user)).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected Integer getAwaitingInvoicesIndicator(User user) {
        List invoiceList = this.invoiceRepo.all().filter(this.getAwaitingInvoicesOfUser(user)).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected String getTotalRemainingIndicator(User user) {
        List invoiceList = this.invoiceRepo.all().filter(this.getTotalRemainingOfUser(user)).fetch();
        if (!invoiceList.isEmpty()) {
            BigDecimal total = invoiceList.stream().map(Invoice::getAmountRemaining).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
            return total.toString() + ((Invoice)((Object)invoiceList.get(0))).getCurrency().getSymbol();
        }
        return BigDecimal.ZERO.toString();
    }

    protected Integer getRefundIndicator(User user) {
        List invoiceList = this.invoiceRepo.all().filter(this.getRefundOfUser(user)).fetch();
        return !invoiceList.isEmpty() ? invoiceList.size() : 0;
    }

    protected Integer getCustomerTicketsIndicator(User user) {
        List ticketList = this.ticketRepo.all().filter(this.getTicketsOfUser(user)).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getCompanyTicketsIndicator(User user) {
        List ticketList = this.ticketRepo.all().filter(this.getCompanyTicketsOfUser(user)).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getResolvedTicketsIndicator(User user) {
        List ticketList = this.ticketRepo.all().filter(this.getResolvedTicketsOfUser(user)).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Object getLateTicketsIndicator(User user) {
        List ticketList = this.ticketRepo.all().filter(this.getLateTicketsOfUser(user)).fetch();
        return !ticketList.isEmpty() ? ticketList.size() : 0;
    }

    protected Integer getTotalProjectsIndicator(User user) {
        List projectList = this.projectRepo.all().filter(this.getTotalProjectsOfUser(user)).fetch();
        return !projectList.isEmpty() ? projectList.size() : 0;
    }

    protected Integer getNewTasksIndicator(User user) {
        List teamTaskList = this.teamTaskRepo.all().filter(this.getNewTasksOfUser(user)).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    protected Integer getTasksInProgressIndicator(User user) {
        List teamTaskList = this.teamTaskRepo.all().filter(this.getTasksInProgressOfUser(user)).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    protected Integer getTasksDueIndicator(User user) {
        List teamTaskList = this.teamTaskRepo.all().filter(this.getTasksDueOfUser(user)).fetch();
        return !teamTaskList.isEmpty() ? teamTaskList.size() : 0;
    }

    @Override
    public String getOrdersInProgressOfUser(User user) {
        String query = "self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect = " + 3;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getQuotationsOfUser(User user) {
        String query = "self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect IN (" + 1 + "," + 2 + ")";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getLastOrderOfUser(User user) {
        String query = "self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect = " + 4;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        query = query + " ORDER BY self.confirmationDateTime DESC";
        return query;
    }

    @Override
    public String getLastDeliveryOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 3 + " AND self.isReversion != true";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        query = query + " ORDER BY self.realDate DESC";
        return query;
    }

    @Override
    public String getNextDeliveryOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 2 + " AND self.isReversion != true";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        query = query + " ORDER BY self.estimatedDate ASC";
        return query;
    }

    @Override
    public String getPlannedDeliveriesOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.statusSelect = " + 2 + " AND self.isReversion != true";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getReversionsOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.typeSelect = " + 2 + " AND self.isReversion = true";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getOverdueInvoicesOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.dueDate < current_date()  AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getAwaitingInvoicesOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getTotalRemainingOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.amountRemaining != 0 AND self.statusSelect != " + 1 + " AND self.statusSelect != " + 4;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getRefundOfUser(User user) {
        String query = "self.partner.id = " + user.getPartner().getId() + " AND self.operationTypeSelect = " + 4;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getTicketsOfUser(User user) {
        return "self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId();
    }

    @Override
    public String getCompanyTicketsOfUser(User user) {
        return "self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getActiveCompany().getId();
    }

    @Override
    public String getResolvedTicketsOfUser(User user) {
        return "self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId() + " AND self.statusSelect IN (" + 2 + ", " + 3 + ")";
    }

    @Override
    public String getLateTicketsOfUser(User user) {
        return "self.customer.id = " + user.getPartner().getId() + " AND self.assignedToUser.id = " + user.getId() + " AND ((self.endDateT != null AND self.endDateT > self.deadlineDateT)  OR (self.endDateT = null and self.deadlineDateT < current_date() ) )";
    }

    @Override
    public String getTotalProjectsOfUser(User user) {
        String query = "self.isProject = true AND self.clientPartner.id = " + user.getPartner().getId() + " AND self.statusSelect != " + ProjectRepository.STATE_CANCELED;
        if (user.getActiveCompany() != null) {
            query = query + " AND self.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getNewTasksOfUser(User user) {
        String query = "self.status = 'new'  AND self.typeSelect = 'task' AND self.project.clientPartner.id = " + user.getPartner().getId();
        if (user.getActiveCompany() != null) {
            query = query + " AND self.project.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getTasksInProgressOfUser(User user) {
        String query = "self.status = 'in-progress' AND self.typeSelect = 'task' AND self.project.clientPartner.id = " + user.getPartner().getId();
        if (user.getActiveCompany() != null) {
            query = query + " AND self.project.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }

    @Override
    public String getTasksDueOfUser(User user) {
        String query = "self.status IN ('in-progress','new') AND self.project.clientPartner.id = " + user.getPartner().getId() + " AND self.typeSelect = '" + "task" + "' AND self.taskEndDate  < current_date() ";
        if (user.getActiveCompany() != null) {
            query = query + " AND self.project.company.id = " + user.getActiveCompany().getId();
        }
        return query;
    }
}

