/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.portal.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.helpdesk.db.Ticket;
import com.axelor.apps.portal.service.ClientViewService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.auth.db.User;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.team.db.TeamTask;
import java.util.Map;

public class ClientViewController {
    public void completeClientViewIndicators(ActionRequest request, ActionResponse response) {
        try {
            Map<String, Object> map = ((ClientViewService)Beans.get(ClientViewService.class)).updateClientViewIndicators();
            response.setValues(map);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyOrdersInProgress(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getOrdersInProgressOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Orders in progress")).model(SaleOrder.class.getName()).add("grid", "sale-order-grid-client").add("form", "sale-order-form-client").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyQuotation(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getQuotationsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"My quotations")).model(SaleOrder.class.getName()).add("grid", "sale-order-grid").add("form", "sale-order-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyLastOrder(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getLastOrderOfUser(clientUser);
            SaleOrder saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).all().filter(domain).fetchOne());
            if (saleOrder != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Last order")).model(SaleOrder.class.getName()).add("form", "sale-order-form-client").context("_showRecord", (Object)saleOrder.getId()).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyTotalProjects(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getTotalProjectsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Total projects")).model(Project.class.getName()).add("grid", "project-grid").add("form", "project-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyNewTasks(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getNewTasksOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"New tasks")).model(TeamTask.class.getName()).add("grid", "team-task-grid").add("form", "team-task-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyTasksInProgress(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getTasksInProgressOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Tasks in progress")).model(TeamTask.class.getName()).add("grid", "team-task-grid").add("form", "team-task-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyTasksDue(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getTasksDueOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Tasks due")).model(TeamTask.class.getName()).add("grid", "team-task-grid").add("form", "team-task-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyLastDelivery(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getLastDeliveryOfUser(clientUser);
            StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter(domain).fetchOne());
            if (stockMove != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Last delivery")).model(StockMove.class.getName()).add("form", "stock-move-form").context("_showRecord", (Object)stockMove.getId()).domain(domain).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyNextDelivery(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getNextDeliveryOfUser(clientUser);
            StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter(domain).fetchOne());
            if (stockMove != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Next delivery")).model(StockMove.class.getName()).add("form", "stock-move-form").context("_showRecord", (Object)stockMove.getId()).domain(domain).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyPlannedDeliveries(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getPlannedDeliveriesOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Planned deliveries")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientReversions(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getReversionsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"My reversions")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyOverdueInvoices(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getOverdueInvoicesOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Overdue invoices")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-client-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyAwaitingInvoices(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getAwaitingInvoicesOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Awaiting invoices")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-client-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyTotalRemaining(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getTotalRemainingOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Total remaining")).model(Invoice.class.getName()).add("grid", "invoice-grid").add("form", "invoice-client-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyRefund(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getRefundOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"My refund")).model(Invoice.class.getName()).add("grid", "invoice-refund-grid").add("form", "invoice-client-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyCustomerTickets(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getTicketsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Customer tickets")).model(Ticket.class.getName()).add("grid", "ticket-grid").add("form", "ticket-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyCompanyTickets(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getCompanyTicketsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Company tickets")).model(Ticket.class.getName()).add("grid", "ticket-grid").add("form", "ticket-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyResolvedTickets(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getResolvedTicketsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Resolved tickets")).model(Ticket.class.getName()).add("grid", "ticket-grid").add("form", "ticket-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showClientMyLateTickets(ActionRequest request, ActionResponse response) {
        try {
            ClientViewService clientViewService = (ClientViewService)Beans.get(ClientViewService.class);
            User clientUser = clientViewService.getClientUser();
            String domain = clientViewService.getLateTicketsOfUser(clientUser);
            response.setView(ActionView.define((String)I18n.get((String)"Late tickets")).model(Ticket.class.getName()).add("grid", "ticket-grid").add("form", "ticket-form").domain(domain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

