/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_STOCK_LOCATION_LINE", indexes={@Index(columnList="stock_location"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="tracking_number"), @Index(columnList="details_stock_location")})
@Track(fields={@TrackField(name="requestedReservedQty"), @TrackField(name="reservedQty")})
public class StockLocationLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_STOCK_LOCATION_LINE_SEQ")
    @SequenceGenerator(name="STOCK_STOCK_LOCATION_LINE_SEQ", sequenceName="STOCK_STOCK_LOCATION_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Stock location", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Product", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Current Qty", readonly=true)
    private BigDecimal currentQty = BigDecimal.ZERO;
    @Widget(title="Future Qty", readonly=true)
    private BigDecimal futureQty = BigDecimal.ZERO;
    @Widget(title="Average Price", readonly=true)
    @Digits(integer=10, fraction=10)
    private BigDecimal avgPrice = BigDecimal.ZERO;
    @Transient
    private Boolean isAvgPriceChanged = Boolean.FALSE;
    @Widget(title="Last Future Stock Move", readonly=true)
    private LocalDate lastFutureStockMoveDate;
    @Widget(title="Rack")
    private String rack;
    @Widget(title="Tracking Nbr", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrackingNumber trackingNumber;
    @Widget(title="Stock location details", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation detailsStockLocation;
    private BigDecimal lastInventoryRealQty = BigDecimal.ZERO;
    @Widget(title="Last inventory date")
    private ZonedDateTime lastInventoryDateT;
    @Widget(title="Allocated qty")
    private BigDecimal reservedQty = BigDecimal.ZERO;
    @Widget(title="Requested reserved qty")
    private BigDecimal requestedReservedQty = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getCurrentQty() {
        return this.currentQty == null ? BigDecimal.ZERO : this.currentQty;
    }

    public void setCurrentQty(BigDecimal currentQty) {
        this.currentQty = currentQty;
    }

    public BigDecimal getFutureQty() {
        return this.futureQty == null ? BigDecimal.ZERO : this.futureQty;
    }

    public void setFutureQty(BigDecimal futureQty) {
        this.futureQty = futureQty;
    }

    public BigDecimal getAvgPrice() {
        return this.avgPrice == null ? BigDecimal.ZERO : this.avgPrice;
    }

    public void setAvgPrice(BigDecimal avgPrice) {
        this.avgPrice = avgPrice;
    }

    public Boolean getIsAvgPriceChanged() {
        return this.isAvgPriceChanged == null ? Boolean.FALSE : this.isAvgPriceChanged;
    }

    public void setIsAvgPriceChanged(Boolean isAvgPriceChanged) {
        this.isAvgPriceChanged = isAvgPriceChanged;
    }

    public LocalDate getLastFutureStockMoveDate() {
        return this.lastFutureStockMoveDate;
    }

    public void setLastFutureStockMoveDate(LocalDate lastFutureStockMoveDate) {
        this.lastFutureStockMoveDate = lastFutureStockMoveDate;
    }

    public String getRack() {
        return this.rack;
    }

    public void setRack(String rack) {
        this.rack = rack;
    }

    public TrackingNumber getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(TrackingNumber trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public StockLocation getDetailsStockLocation() {
        return this.detailsStockLocation;
    }

    public void setDetailsStockLocation(StockLocation detailsStockLocation) {
        this.detailsStockLocation = detailsStockLocation;
    }

    public BigDecimal getLastInventoryRealQty() {
        return this.lastInventoryRealQty == null ? BigDecimal.ZERO : this.lastInventoryRealQty;
    }

    public void setLastInventoryRealQty(BigDecimal lastInventoryRealQty) {
        this.lastInventoryRealQty = lastInventoryRealQty;
    }

    public ZonedDateTime getLastInventoryDateT() {
        return this.lastInventoryDateT;
    }

    public void setLastInventoryDateT(ZonedDateTime lastInventoryDateT) {
        this.lastInventoryDateT = lastInventoryDateT;
    }

    public BigDecimal getReservedQty() {
        return this.reservedQty == null ? BigDecimal.ZERO : this.reservedQty;
    }

    public void setReservedQty(BigDecimal reservedQty) {
        this.reservedQty = reservedQty;
    }

    public BigDecimal getRequestedReservedQty() {
        return this.requestedReservedQty == null ? BigDecimal.ZERO : this.requestedReservedQty;
    }

    public void setRequestedReservedQty(BigDecimal requestedReservedQty) {
        this.requestedReservedQty = requestedReservedQty;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StockLocationLine)) {
            return false;
        }
        StockLocationLine other = (StockLocationLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("currentQty", (Object)this.getCurrentQty()).add("futureQty", (Object)this.getFutureQty()).add("avgPrice", (Object)this.getAvgPrice()).add("isAvgPriceChanged", (Object)this.getIsAvgPriceChanged()).add("lastFutureStockMoveDate", (Object)this.getLastFutureStockMoveDate()).add("rack", (Object)this.getRack()).add("lastInventoryRealQty", (Object)this.getLastInventoryRealQty()).add("lastInventoryDateT", (Object)this.getLastInventoryDateT()).add("reservedQty", (Object)this.getReservedQty()).add("requestedReservedQty", (Object)this.getRequestedReservedQty()).omitNullValues().toString();
    }
}

