/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.production.db.CostSheetLine;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.CostSheetLineService;
import com.axelor.apps.production.service.costsheet.CostSheetServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostSheetServiceBusinessImpl
extends CostSheetServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public CostSheetServiceBusinessImpl(AppProductionService appProductionService, UnitConversionService unitConversionService, CostSheetLineService costSheetLineService, BillOfMaterialRepository billOfMaterialRepo) {
        super(appProductionService, unitConversionService, costSheetLineService, billOfMaterialRepo);
    }

    protected void _computeHumanResourceCost(ProdHumanResource prodHumanResource, int priority, int bomLevel, CostSheetLine parentCostSheetLine) throws AxelorException {
        Employee employee = prodHumanResource.getEmployee();
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (appProductionService.isApp("production") && appProductionService.getAppProduction().getManageBusinessProduction().booleanValue() && employee != null) {
            BigDecimal durationHours = new BigDecimal(prodHumanResource.getDuration()).divide(BigDecimal.valueOf(3600L), appProductionService.getNbDecimalDigitForUnitPrice(), 6);
            this.costSheet.addCostSheetLineListItem(this.costSheetLineService.createWorkCenterHRCostSheetLine(prodHumanResource.getWorkCenter(), prodHumanResource, priority, bomLevel, parentCostSheetLine, durationHours, employee.getHourlyRate().multiply(durationHours), this.hourUnit));
        } else {
            super._computeHumanResourceCost(prodHumanResource, priority, bomLevel, parentCostSheetLine);
        }
    }

    protected void computeRealHumanResourceCost(OperationOrder operationOrder, int priority, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) throws AxelorException {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            super.computeRealHumanResourceCost(operationOrder, priority, bomLevel, parentCostSheetLine, previousCostSheetDate);
            return;
        }
        if (operationOrder.getTimesheetLineList() != null) {
            Long duration = 0L;
            if (parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 2 || parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 1) {
                Period period = previousCostSheetDate != null ? Period.between(parentCostSheetLine.getCostSheet().getCalculationDate(), previousCostSheetDate) : null;
                duration = period != null ? Long.valueOf(period.getDays() * 24) : operationOrder.getRealDuration();
            } else if (parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 3) {
                duration = operationOrder.getRealDuration() - operationOrder.getPlannedDuration() * this.costSheet.getManufOrderProducedRatio().longValue();
            }
            this.computeRealHumanResourceCost(null, operationOrder.getWorkCenter(), priority, bomLevel, parentCostSheetLine, duration);
        }
    }
}

