/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.businessproject.db.InvoicingProject;
import com.axelor.apps.businessproject.service.InvoicingProjectService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;

public class InvoicingProjectServiceBusinessProdImpl
extends InvoicingProjectService {
    public void setLines(InvoicingProject invoicingProject, Project project, int counter) {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            super.setLines(invoicingProject, project, counter);
            return;
        }
        if (counter > 10) {
            return;
        }
        ++counter;
        this.fillLines(invoicingProject, project);
        if (!invoicingProject.getConsolidatePhaseWhenInvoicing().booleanValue()) {
            return;
        }
        List projectChildrenList = ((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).all().filter("self.parentProject = ?1", new Object[]{project}).fetch();
        for (Project projectChild : projectChildrenList) {
            this.setLines(invoicingProject, projectChild, counter);
        }
    }

    public void fillLines(InvoicingProject invoicingProject, Project project) {
        super.fillLines(invoicingProject, project);
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return;
        }
        if (invoicingProject.getManufOrderSet() == null) {
            invoicingProject.setManufOrderSet(new HashSet<ManufOrder>());
        }
        if (invoicingProject.getDeadlineDate() != null) {
            LocalDateTime deadlineDateToDateTime = invoicingProject.getDeadlineDate().atStartOfDay();
            invoicingProject.getManufOrderSet().addAll(((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter("self.productionOrder.project = ?1 AND (self.realStartDateT < ?2)", new Object[]{project, deadlineDateToDateTime}).fetch());
        } else {
            invoicingProject.getManufOrderSet().addAll(((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter("self.productionOrder.project = ?1", new Object[]{project}).fetch());
        }
    }

    public void clearLines(InvoicingProject invoicingProject) {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        super.clearLines(invoicingProject);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return;
        }
        invoicingProject.setManufOrderSet(new HashSet<ManufOrder>());
    }

    public int countToInvoice(Project project) {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        int toInvoiceCount = super.countToInvoice(project);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return toInvoiceCount;
        }
        int productionOrderCount = (int)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter("self.productionOrder.project = ?1", new Object[]{project}).count();
        return toInvoiceCount += productionOrderCount;
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public InvoicingProject generateInvoicingProject(Project project, int consolidatePhaseSelect) {
        InvoicingProject invoicingProject = super.generateInvoicingProject(project, consolidatePhaseSelect);
        if (invoicingProject != null && invoicingProject.getId() == null && !invoicingProject.getManufOrderSet().isEmpty()) {
            return (InvoicingProject)((Object)this.invoicingProjectRepo.save((Model)((Object)invoicingProject)));
        }
        return invoicingProject;
    }
}

