/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.businessproduction.service.OperationOrderTimesheetService;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.operationorder.OperationOrderWorkflowService;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationOrderTimesheetServiceImpl
implements OperationOrderTimesheetService {
    @Override
    @Transactional
    public void updateOperationOrder(OperationOrder operationOrder, List<TimesheetLine> oldTimesheetLineList, List<TimesheetLine> newTimesheetLineList) {
        ArrayList<TimesheetLine> operationOrderTsLineList = new ArrayList<TimesheetLine>(operationOrder.getTimesheetLineList());
        operationOrderTsLineList.removeAll(oldTimesheetLineList);
        operationOrderTsLineList.addAll(newTimesheetLineList.stream().filter(timesheetLine -> operationOrder.equals((Object)timesheetLine.getOperationOrder())).collect(Collectors.toList()));
        long durationLong = DurationTool.getSecondsDuration((Duration)((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeTotalDuration(operationOrderTsLineList));
        operationOrder.setRealDuration(durationLong);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateOperationOrders(Timesheet timesheet) throws AxelorException {
        if (timesheet.getTimesheetLineList() == null) {
            return;
        }
        TimesheetLineService timesheetLineService = (TimesheetLineService)Beans.get(TimesheetLineService.class);
        for (TimesheetLine timesheetLine : timesheet.getTimesheetLineList()) {
            BigDecimal hoursDuration = timesheetLineService.computeHoursDuration(timesheet, timesheetLine.getDuration(), true);
            timesheetLine.setHoursDuration(hoursDuration);
        }
        if (!((AppProductionService)Beans.get(AppProductionService.class)).getAppProduction().getEnableTimesheetOnManufOrder().booleanValue()) {
            return;
        }
        List oldTimesheetLineList = ((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).all().filter("self.timesheet.id = :timesheetId").bind("timesheetId", (Object)timesheet.getId()).fetch();
        List newTimesheetLineList = timesheet.getTimesheetLineList();
        ArrayList allTimesheetLineList = new ArrayList(oldTimesheetLineList);
        allTimesheetLineList.addAll(newTimesheetLineList);
        List<OperationOrder> operationOrdersToUpdate = allTimesheetLineList.stream().map(TimesheetLine::getOperationOrder).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        operationOrdersToUpdate.forEach(operationOrder -> this.updateOperationOrder((OperationOrder)((Object)operationOrder), oldTimesheetLineList, newTimesheetLineList));
    }

    @Override
    public void updateAllRealDuration(List<TimesheetLine> timesheetLineList) {
        if (timesheetLineList == null) {
            return;
        }
        List<OperationOrder> operationOrderList = timesheetLineList.stream().map(TimesheetLine::getOperationOrder).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OperationOrderWorkflowService operationOrderWorkflowService = (OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class);
        operationOrderList.forEach(arg_0 -> ((OperationOrderWorkflowService)operationOrderWorkflowService).updateRealDuration(arg_0));
    }
}

