/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.repo.OperationOrderDurationRepository;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.operationorder.OperationOrderStockMoveService;
import com.axelor.apps.production.service.operationorder.OperationOrderWorkflowService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.Duration;
import java.util.List;

public class OperationOrderWorkflowServiceBusinessImpl
extends OperationOrderWorkflowService {
    @Inject
    public OperationOrderWorkflowServiceBusinessImpl(OperationOrderStockMoveService operationOrderStockMoveService, OperationOrderRepository operationOrderRepo, OperationOrderDurationRepository operationOrderDurationRepo, AppProductionService appProductionService) {
        super(operationOrderStockMoveService, operationOrderRepo, operationOrderDurationRepo, appProductionService);
    }

    public Duration computeRealDuration(OperationOrder operationOrder) {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (appProductionService.isApp("production") && appProductionService.getAppProduction().getManageBusinessProduction().booleanValue() && appProductionService.getAppProduction().getEnableTimesheetOnManufOrder().booleanValue()) {
            List<TimesheetLine> timesheetLineList = operationOrder.getTimesheetLineList();
            return ((TimesheetLineService)Beans.get(TimesheetLineService.class)).computeTotalDuration(timesheetLineList);
        }
        return super.computeRealDuration(operationOrder);
    }
}

