/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.businessproduction.service.ProductionOrderServiceBusinessImpl;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderSaleOrderServiceImpl;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionOrderSaleOrderServiceBusinessImpl
extends ProductionOrderSaleOrderServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ProductionOrderServiceBusinessImpl productionOrderServiceBusinessImpl;

    @Inject
    public ProductionOrderSaleOrderServiceBusinessImpl(UnitConversionService unitConversionService, ProductionOrderService productionOrderService, ProductionOrderRepository productionOrderRepo, ProductionOrderServiceBusinessImpl productionOrderServiceBusinessImpl, AppProductionService appProductionService) {
        super(unitConversionService, productionOrderService, productionOrderRepo, appProductionService);
        this.productionOrderServiceBusinessImpl = productionOrderServiceBusinessImpl;
    }

    protected ProductionOrder createProductionOrder(SaleOrder saleOrder) throws AxelorException {
        ProductionOrder productionOrder = super.createProductionOrder(saleOrder);
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (appProductionService.isApp("production") && appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            productionOrder.setProject(saleOrder.getProject());
        }
        return productionOrder;
    }

    @Transactional(rollbackOn={Exception.class})
    public void createSaleOrder(ProductionOrder productionOrder) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'un devis client pour l'ordre de production : {}", new Object[]{productionOrder.getProductionOrderSeq()});
        Project project = productionOrder.getProject();
        project.getClientPartner();
    }
}

