/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_LOGISTICAL_FORM_LINE", uniqueConstraints={@UniqueConstraint(columnNames={"typeSelect", "parcelPalletNumber", "logistical_form"})}, indexes={@Index(columnList="logistical_form"), @Index(columnList="stock_move_line"), @Index(columnList="sale_order")})
public class LogisticalFormLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_LOGISTICAL_FORM_LINE_SEQ")
    @SequenceGenerator(name="STOCK_LOGISTICAL_FORM_LINE_SEQ", sequenceName="STOCK_LOGISTICAL_FORM_LINE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LogisticalForm logisticalForm;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Type", selection="logistical.form.line.type.select")
    @NotNull
    private Integer typeSelect = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMoveLine stockMoveLine;
    @Column(nullable=true)
    private BigDecimal qty;
    @Widget(title="Parcel/pallet number")
    @Column(nullable=true)
    private Integer parcelPalletNumber;
    @Digits(integer=17, fraction=2)
    @Column(nullable=true)
    private BigDecimal grossMass;
    @Widget(title="Dimensions (cm)")
    @Column(nullable=true)
    private String dimensions;
    @Widget(readonly=true)
    @Digits(integer=10, fraction=10)
    @Column(nullable=true)
    private BigDecimal unitNetMass;
    @Widget(title="Sale Order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LogisticalForm getLogisticalForm() {
        return this.logisticalForm;
    }

    public void setLogisticalForm(LogisticalForm logisticalForm) {
        this.logisticalForm = logisticalForm;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public StockMoveLine getStockMoveLine() {
        return this.stockMoveLine;
    }

    public void setStockMoveLine(StockMoveLine stockMoveLine) {
        this.stockMoveLine = stockMoveLine;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Integer getParcelPalletNumber() {
        return this.parcelPalletNumber;
    }

    public void setParcelPalletNumber(Integer parcelPalletNumber) {
        this.parcelPalletNumber = parcelPalletNumber;
    }

    public BigDecimal getGrossMass() {
        return this.grossMass;
    }

    public void setGrossMass(BigDecimal grossMass) {
        this.grossMass = grossMass;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public BigDecimal getUnitNetMass() {
        return this.unitNetMass;
    }

    public void setUnitNetMass(BigDecimal unitNetMass) {
        this.unitNetMass = unitNetMass;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogisticalFormLine)) {
            return false;
        }
        LogisticalFormLine other = (LogisticalFormLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("typeSelect", (Object)this.getTypeSelect()).add("qty", (Object)this.getQty()).add("parcelPalletNumber", (Object)this.getParcelPalletNumber()).add("grossMass", (Object)this.getGrossMass()).add("dimensions", (Object)this.getDimensions()).add("unitNetMass", (Object)this.getUnitNetMass()).omitNullValues().toString();
    }
}

