/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app;

import com.axelor.app.AxelorModule;
import com.axelor.event.EventModule;
import com.axelor.inject.Beans;
import com.axelor.inject.logger.LoggerModule;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.meta.loader.ViewObserver;
import com.axelor.report.ReportEngineProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppModule
extends AbstractModule {
    private static Logger log = LoggerFactory.getLogger(AppModule.class);

    protected void configure() {
        this.bind(Beans.class).asEagerSingleton();
        this.bind(IReportEngine.class).toProvider(ReportEngineProvider.class);
        this.bind(ViewObserver.class);
        this.install((Module)new LoggerModule());
        this.install((Module)new EventModule());
        List moduleClasses = ModuleManager.findInstalled().stream().flatMap(name -> MetaScanner.findSubTypesOf(name, AxelorModule.class).find().stream()).collect(Collectors.toList());
        if (moduleClasses.isEmpty()) {
            return;
        }
        log.info("Configuring app modules...");
        for (Class module : moduleClasses) {
            try {
                log.debug("Configure module: {}", (Object)module.getName());
                this.install((Module)module.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

