/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app;

import com.axelor.app.internal.AppFilter;
import com.axelor.common.ResourceUtils;
import com.axelor.common.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class AppSettings {
    private static final String DEFAULT_CONFIG_LOCATION = "application.properties";
    private static final String CUSTOM_CONFIG_LOCATION = "axelor.config";
    private Properties properties;
    private static AppSettings instance;

    private AppSettings() {
        String config = System.getProperty(CUSTOM_CONFIG_LOCATION);
        InputStream stream = null;
        try {
            if (StringUtils.isBlank((CharSequence)config)) {
                config = DEFAULT_CONFIG_LOCATION;
                stream = ResourceUtils.getResourceStream((String)DEFAULT_CONFIG_LOCATION);
            } else {
                stream = new FileInputStream(config);
            }
            try {
                this.properties = new LinkedProperties();
                this.properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load application settings: " + config);
        }
    }

    public static AppSettings get() {
        if (instance == null) {
            instance = new AppSettings();
        }
        return instance;
    }

    public String get(String key) {
        return this.sub(this.properties.getProperty(key));
    }

    public String get(String key, String defaultValue) {
        String value = this.properties.getProperty(key, defaultValue);
        if (value == null || "".equals(value.trim())) {
            value = defaultValue;
        }
        return this.sub(value);
    }

    public List<String> getList(String key) {
        return Arrays.stream(this.get(key, "").trim().split("\\s*,\\s*")).filter(StringUtils::notBlank).collect(Collectors.toList());
    }

    public <T> List<T> getList(String key, Function<String, T> mapper) {
        return this.getList(key).stream().map(mapper).collect(Collectors.toList());
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.get(key).toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.get(key).toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String getPath(String key, String defaultValue) {
        String path = this.get(key, defaultValue);
        if (path == null) {
            return null;
        }
        return this.sub(path);
    }

    private String sub(String value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        return value.replace("{year}", "" + cal.get(1)).replace("{month}", "" + cal.get(2)).replace("{day}", "" + cal.get(5)).replace("{java.io.tmpdir}", System.getProperty("java.io.tmpdir")).replace("{user.home}", System.getProperty("user.home"));
    }

    public String getBaseURL() {
        String url = AppFilter.getBaseURL();
        if (url == null) {
            url = this.get("application.baseUrl");
        }
        return url;
    }

    public boolean isProduction() {
        return !"dev".equals(this.get("application.mode", "dev"));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class LinkedProperties
    extends Properties {
        private static final long serialVersionUID = -1869328576799427860L;
        private final Set<Object> keys = new LinkedHashSet<Object>();

        @Override
        public synchronized Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        @Override
        public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
            this.keys.addAll(t.keySet());
            super.putAll(t);
        }

        @Override
        public synchronized Object remove(Object key) {
            this.keys.remove(key);
            return super.remove(key);
        }

        @Override
        public synchronized boolean remove(Object key, Object value) {
            this.keys.remove(key);
            return super.remove(key, value);
        }

        @Override
        public Set<Object> keySet() {
            return Collections.unmodifiableSet(this.keys);
        }

        @Override
        public Set<String> stringPropertyNames() {
            return this.keys.stream().map(Object::toString).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }
}

