/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app.internal;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class AppFilter
implements Filter {
    private static final ThreadLocal<String> BASE_URL = new ThreadLocal();
    private static final ThreadLocal<Locale> LANGUAGE = new ThreadLocal();
    private static Locale APP_LOCALE;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            String appLocale = AppSettings.get().get("application.locale", null);
            APP_LOCALE = appLocale == null ? null : new Locale(appLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getBaseURL() {
        return BASE_URL.get();
    }

    public static Locale getLocale() {
        User user = AuthUtils.getUser();
        if (user != null && user.getLanguage() != null) {
            return new Locale(user.getLanguage());
        }
        if (user != null && APP_LOCALE != null) {
            return APP_LOCALE;
        }
        if (LANGUAGE.get() == null) {
            return Locale.getDefault();
        }
        return LANGUAGE.get();
    }

    private String getHeader(ServletRequest req, String name, String defaultValue) {
        String value = ((HttpServletRequest)req).getHeader(name);
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }

    private String getBaseUrl(ServletRequest req) {
        String proto = this.getHeader(req, "X-Forwarded-Proto", req.getScheme());
        String port = this.getHeader(req, "X-Forwarded-Port", "" + req.getServerPort());
        String host = this.getHeader(req, "X-Forwarded-Host", req.getServerName());
        String context = this.getHeader(req, "X-Forwarded-Context", req.getServletContext().getContextPath());
        return port.equals("80") || port.equals("443") ? proto + "://" + host + context : proto + "://" + host + ":" + port + context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        BASE_URL.set(this.getBaseUrl(request));
        LANGUAGE.set(request.getLocale());
        try {
            chain.doFilter(request, response);
        }
        finally {
            LANGUAGE.remove();
            BASE_URL.remove();
        }
    }

    public void destroy() {
        LANGUAGE.remove();
        BASE_URL.remove();
    }
}

