/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app.internal;

import com.axelor.app.AppSettings;
import com.axelor.common.logging.LoggerConfiguration;
import java.util.Properties;
import java.util.function.Predicate;

public final class AppLogger {
    private static LoggerConfiguration configuration;

    private AppLogger() {
    }

    private static LoggerConfiguration createLoggerConfig() {
        AppSettings settings = AppSettings.get();
        Properties loggingConfig = new Properties();
        Predicate<String> isLogging = n -> n.startsWith("logging.");
        settings.getProperties().stringPropertyNames().stream().filter(isLogging).forEach(n -> loggingConfig.setProperty((String)n, settings.get((String)n)));
        if (loggingConfig.containsKey("logging.path")) {
            loggingConfig.setProperty("logging.path", settings.getPath("logging.path", null));
        }
        return new LoggerConfiguration(loggingConfig);
    }

    public static void install() {
        if (configuration == null) {
            configuration = AppLogger.createLoggerConfig();
            configuration.install();
        }
    }

    public static void uninstall() {
        if (configuration != null) {
            configuration.uninstall();
            configuration = null;
        }
    }
}

