/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public final class AppRunner {
    private static void run(String[] args) {
        Path runnerJar = Paths.get("build", "tomcat", "axelor-tomcat.jar");
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarFile jar = new JarFile(runnerJar.toFile());){
            URL[] cp = jar.getManifest().getMainAttributes().getValue("Class-Path");
            String[] stringArray = cp.split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                urls.add(Paths.get(s.trim(), new String[0]).toUri().toURL());
            }
        }
        catch (IOException e) {
            System.err.println("invalid jar: " + runnerJar);
            System.err.println("please run 'runnerJar' grade task");
            return;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ClassLoader parentClassLoader = systemClassLoader.getParent();
        for (URL url : ((URLClassLoader)systemClassLoader).getURLs()) {
            if (!url.toString().contains("hotswap-agent")) continue;
            urls.add(url);
            parentClassLoader = new FilteringClassLoader(systemClassLoader);
            break;
        }
        try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[0]), parentClassLoader);){
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> runnerClass = loader.loadClass("com.axelor.tomcat.TomcatRunner");
            Method runnerMain = runnerClass.getMethod("main", String[].class);
            runnerMain.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isTestPath(URL url) {
        try {
            Path path;
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            for (path = Paths.get(url.toURI()); path != null && !Files.exists(path.resolve("build.gradle"), new LinkOption[0]); path = path.getParent()) {
                if (!path.getFileName().toString().equals("test")) continue;
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        URLClassLoader systemLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        List<URL> urls = Arrays.stream(systemLoader.getURLs()).filter(u -> !AppRunner.isTestPath(u)).collect(Collectors.toList());
        try (URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[0]), null);){
            Thread.currentThread().setContextClassLoader(loader);
            Properties props = new Properties();
            props.load(loader.getResourceAsStream("application.properties"));
            Class<?> loggerClass = loader.loadClass("com.axelor.common.logging.LoggerConfiguration");
            Object logger = loggerClass.getConstructor(Properties.class).newInstance(props);
            Method install = loggerClass.getDeclaredMethod("install", new Class[0]);
            Method uninstall = loggerClass.getDeclaredMethod("uninstall", new Class[0]);
            install.invoke(logger, new Object[0]);
            try {
                AppRunner.run(args);
            }
            finally {
                uninstall.invoke(logger, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(systemLoader);
        }
    }

    private static class FilteringClassLoader
    extends URLClassLoader {
        private static final ClassLoader EXT_LOADER = ClassLoader.getSystemClassLoader().getParent();
        private static final String[] ALLOWED_PACKAGES = new String[]{"org.hotswap"};

        public FilteringClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return EXT_LOADER.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.classAllowed(name)) {
                    throw new ClassNotFoundException(name);
                }
                Class<?> cl = super.loadClass(name, false);
                if (resolve) {
                    this.resolveClass(cl);
                }
                return cl;
            }
        }

        private boolean classAllowed(String className) {
            for (String prefix : ALLOWED_PACKAGES) {
                if (!className.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }

        @Override
        public URL getResource(String name) {
            return EXT_LOADER.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return EXT_LOADER.getResources(name);
        }
    }
}

