/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuditTracker;
import com.axelor.auth.AuditableRunner;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.JpaSequence;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.db.MetaSequence;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.PersistenceException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class AuditInterceptor
extends EmptyInterceptor {
    private final ThreadLocal<User> currentUser = new ThreadLocal();
    private final ThreadLocal<AuditTracker> tracker = new ThreadLocal();
    private static final String UPDATED_BY = "updatedBy";
    private static final String UPDATED_ON = "updatedOn";
    private static final String CREATED_BY = "createdBy";
    private static final String CREATED_ON = "createdOn";
    private static final String ADMIN_USER = "admin";
    private static final String ADMIN_GROUP = "admins";
    private static final String ADMIN_CHECK_FIELD = "code";

    public void afterTransactionBegin(Transaction tx) {
        this.currentUser.set(AuthUtils.getUser());
        this.tracker.set(new AuditTracker());
    }

    public void afterTransactionCompletion(Transaction tx) {
        this.tracker.get().clear();
        this.tracker.remove();
        this.currentUser.remove();
    }

    public void beforeTransactionCompletion(Transaction tx) {
        this.tracker.get().onComplete(tx, this.getUser());
    }

    private User getUser() {
        User user = this.currentUser.get();
        if (user == null) {
            user = AuditableRunner.batchUser.get();
        }
        if (user == null || JPA.em().contains((Object)user)) {
            return user;
        }
        if ((user = AuthUtils.getUser(user.getCode())) == null) {
            return null;
        }
        this.currentUser.remove();
        this.currentUser.set(user);
        return user;
    }

    private boolean canUpdate(Object entity, String field, Object prevValue, Object newValue) {
        if (!(entity instanceof Model) || ((Model)entity).getId() == null) {
            return true;
        }
        if (entity instanceof User || entity instanceof Group) {
            if (!ADMIN_CHECK_FIELD.equals(field)) {
                return true;
            }
            if (entity instanceof User && ADMIN_USER.equals(prevValue) && !ADMIN_USER.equals(newValue)) {
                return false;
            }
            if (entity instanceof Group && ADMIN_GROUP.equals(prevValue) && !ADMIN_GROUP.equals(newValue)) {
                return false;
            }
        }
        return true;
    }

    private boolean canDelete(Object entity) {
        if (entity instanceof User && ADMIN_USER.equals(((User)entity).getCode())) {
            return false;
        }
        return !(entity instanceof Group) || !ADMIN_GROUP.equals(((Group)entity).getCode());
    }

    private boolean updateSequence(Object entity, String[] names, Object[] state) {
        if (entity instanceof MetaSequence || !(entity instanceof Model)) {
            return false;
        }
        Mapper mapper = Mapper.of(EntityHelper.getEntityClass(entity));
        boolean updated = false;
        for (int i = 0; i < names.length; ++i) {
            Property property;
            if (state[i] != null || (property = mapper.getProperty(names[i])) == null || !property.isSequence()) continue;
            state[i] = JpaSequence.nextValue(property.getSequenceName());
            updated = true;
        }
        return updated;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (!(entity instanceof AuditableModel)) {
            return false;
        }
        User user = this.getUser();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!this.canUpdate(entity, propertyNames[i], previousState[i], currentState[i])) {
                throw new PersistenceException(String.format("You can't update: %s#%s, values (%s=%s)", entity.getClass().getName(), id, propertyNames[i], currentState[i]));
            }
            if (UPDATED_ON.equals(propertyNames[i])) {
                currentState[i] = LocalDateTime.now();
            }
            if (!UPDATED_BY.equals(propertyNames[i]) || user == null) continue;
            currentState[i] = user;
        }
        if (this.tracker.get() != null) {
            this.tracker.get().track((AuditableModel)entity, propertyNames, currentState, previousState);
        }
        return true;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean changed = this.updateSequence(entity, propertyNames, state);
        if (!(entity instanceof AuditableModel)) {
            return changed;
        }
        User user = this.getUser();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (state[i] != null) continue;
            if (CREATED_ON.equals(propertyNames[i])) {
                state[i] = LocalDateTime.now();
            }
            if (!CREATED_BY.equals(propertyNames[i]) || user == null) continue;
            state[i] = user;
        }
        if (this.tracker.get() != null) {
            this.tracker.get().track((AuditableModel)entity, propertyNames, state, null);
        }
        return true;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (!this.canDelete(entity)) {
            throw new PersistenceException(String.format("You can't delete: %s#%s", entity.getClass().getName(), id));
        }
        if (this.tracker.get() != null && entity instanceof Model) {
            this.tracker.get().delete((Model)entity);
        }
    }
}

