/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.common.Inflector;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailFollower;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.meta.MetaFiles;
import com.axelor.script.CompositeScriptHelper;
import com.axelor.script.ScriptBindings;
import com.axelor.script.ScriptHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Transaction;

final class AuditTracker {
    private static final ThreadLocal<Map<String, EntityState>> STORE = new ThreadLocal();
    private static final ThreadLocal<Set<Model>> DELETED = new ThreadLocal();
    private ObjectMapper objectMapper;

    AuditTracker() {
    }

    private String toJSON(Object value) {
        if (this.objectMapper == null) {
            this.objectMapper = Beans.get(ObjectMapper.class);
        }
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Track getTrack(AuditableModel entity) {
        if (entity == null) {
            return null;
        }
        return entity.getClass().getAnnotation(Track.class);
    }

    private boolean hasEvent(TrackEvent[] events, TrackEvent event) {
        for (TrackEvent e : events) {
            if (e != event && e != TrackEvent.ALWAYS) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvent(Track track, TrackField field, TrackEvent event) {
        return this.hasEvent(field.on(), event) || field.on().length == 0 && this.hasEvent(track.on(), event);
    }

    private boolean hasEvent(Track track, TrackMessage message, TrackEvent event) {
        return this.hasEvent(message.on(), event) || message.on().length == 0 && this.hasEvent(track.on(), event);
    }

    private String format(Property property, Object value) {
        if (value == null) {
            return "";
        }
        if (value == Boolean.TRUE) {
            return "True";
        }
        if (value == Boolean.FALSE) {
            return "False";
        }
        switch (property.getType()) {
            case MANY_TO_ONE: 
            case ONE_TO_ONE: {
                try {
                    return Mapper.of(property.getTarget()).get(value, property.getTargetName()).toString();
                }
                catch (Exception exception) {
                    break;
                }
            }
            case ONE_TO_MANY: 
            case MANY_TO_MANY: {
                return "N/A";
            }
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    public void track(AuditableModel entity, String[] names, Object[] state, Object[] previousState) {
        int i;
        Track track = this.getTrack(entity);
        if (track == null) {
            return;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        for (i = 0; i < names.length; ++i) {
            values.put(names[i], state[i]);
        }
        if (previousState != null) {
            for (i = 0; i < names.length; ++i) {
                oldValues.put(names[i], previousState[i]);
            }
        }
        EntityState.create(entity, values, oldValues);
    }

    public void delete(Model entity) {
        if (DELETED.get() == null) {
            DELETED.set(new HashSet());
        }
        DELETED.get().add(entity);
    }

    private String findMessage(Track track, TrackMessage[] messages, Map<String, Object> values, Map<String, Object> oldValues, ScriptHelper scriptHelper) {
        for (TrackMessage tm : messages) {
            if (!this.hasEvent(track, tm, oldValues.isEmpty() ? TrackEvent.CREATE : TrackEvent.UPDATE)) continue;
            boolean matched = tm.fields().length == 0;
            for (String field : tm.fields()) {
                if (StringUtils.isBlank((CharSequence)field)) {
                    matched = true;
                    break;
                }
                boolean bl = oldValues.isEmpty() ? values.containsKey(field) : (matched = !Objects.equal((Object)values.get(field), (Object)oldValues.get(field)));
                if (matched) break;
            }
            if (!matched || !StringUtils.isBlank((CharSequence)tm.tag()) || !scriptHelper.test(tm.condition())) continue;
            String msg = tm.message();
            if (msg != null && msg.indexOf("#{") == 0) {
                msg = (String)scriptHelper.eval(msg);
            }
            return msg;
        }
        return null;
    }

    private void process(EntityState state, User user) {
        AuditableModel entity = state.entity;
        Mapper mapper = Mapper.of(entity.getClass());
        MailMessage message = new MailMessage();
        Track track = this.getTrack(entity);
        Map values = state.values;
        Map oldValues = state.oldValues;
        Map previousState = oldValues.isEmpty() ? null : oldValues;
        ScriptBindings bindings = new ScriptBindings(state.values);
        CompositeScriptHelper scriptHelper = new CompositeScriptHelper(bindings);
        ArrayList tags = new ArrayList();
        ArrayList tracks = new ArrayList();
        HashSet<String> tagFields = new HashSet<String>();
        String msg = this.findMessage(track, track.messages(), values, oldValues, scriptHelper);
        String content = this.findMessage(track, track.contents(), values, oldValues, scriptHelper);
        for (TrackField trackField : track.fields()) {
            if (!this.hasEvent(track, trackField, TrackEvent.ALWAYS) && !this.hasEvent(track, trackField, previousState == null ? TrackEvent.CREATE : TrackEvent.UPDATE) || !StringUtils.isBlank((CharSequence)trackField.condition()) && !scriptHelper.test(trackField.condition())) continue;
            String name = trackField.name();
            String[] property = mapper.getProperty(name);
            String title = property.getTitle();
            if (StringUtils.isBlank((CharSequence)title)) {
                title = Inflector.getInstance().humanize(name);
            }
            Object value = values.get(name);
            Object oldValue = oldValues.get(name);
            if (previousState != null && Objects.equal(value, oldValue)) continue;
            tagFields.add(name);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("name", property.getName());
            item.put("title", title);
            item.put("value", this.format((Property)property, value));
            if (oldValue != null) {
                item.put("oldValue", this.format((Property)property, oldValue));
            }
            tracks.add(item);
        }
        for (Annotation annotation : track.messages()) {
            boolean canTag = annotation.fields().length == 0 || annotation.fields().length == 1 && StringUtils.isBlank((CharSequence)annotation.fields()[0]);
            for (String name : annotation.fields()) {
                if (!StringUtils.isBlank((CharSequence)name) && (canTag = tagFields.contains(name))) break;
            }
            if (!canTag || !this.hasEvent(track, (TrackMessage)annotation, previousState == null ? TrackEvent.CREATE : TrackEvent.UPDATE) || StringUtils.isBlank((CharSequence)annotation.tag()) || !scriptHelper.test(annotation.condition())) continue;
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("title", annotation.message());
            item.put("style", annotation.tag());
            tags.add(item);
        }
        if (msg == null && content == null && tracks.isEmpty()) {
            return;
        }
        if (msg == null) {
            msg = previousState == null ? "Record created" : "Record updated";
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("title", msg);
        json.put("tags", tags);
        json.put("tracks", tracks);
        if (!StringUtils.isBlank((CharSequence)content)) {
            json.put("content", content);
        }
        message.setSubject(msg);
        message.setBody(this.toJSON(json));
        message.setAuthor(user);
        message.setRelatedId(entity.getId());
        message.setRelatedModel(entity.getClass().getName());
        message.setType("notification");
        Beans.get(MailMessageRepository.class).save(message);
        try {
            message.setRelatedName(mapper.getNameField().get(entity).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (previousState == null && track.subscribe()) {
            MailFollower follower = new MailFollower();
            follower.setRelatedId(entity.getId());
            follower.setRelatedModel(entity.getClass().getName());
            follower.setUser(user);
            follower.setArchived(false);
            Beans.get(MailFollowerRepository.class).save(follower);
        }
    }

    private void processTracks(Transaction tx, User user) {
        Map<String, EntityState> store = STORE.get();
        if (store == null) {
            return;
        }
        STORE.remove();
        for (EntityState state : store.values()) {
            this.process(state, user);
        }
    }

    private void processDelete(Transaction tx, User user) {
        Set<Model> deleted = DELETED.get();
        if (deleted == null) {
            return;
        }
        MetaFiles files = Beans.get(MetaFiles.class);
        DELETED.remove();
        for (Model entity : deleted) {
            files.deleteAttachments(entity);
        }
    }

    public void clear() {
        STORE.remove();
    }

    public void onComplete(Transaction tx, User user) {
        try {
            this.processTracks(tx, user);
            this.processDelete(tx, user);
        }
        finally {
            STORE.remove();
            DELETED.remove();
            JPA.em().flush();
        }
    }

    private static class EntityState {
        private AuditableModel entity;
        private Map<String, Object> values;
        private Map<String, Object> oldValues;

        private EntityState() {
        }

        public static void create(AuditableModel entity, Map<String, Object> values, Map<String, Object> oldValues) {
            if (STORE.get() == null) {
                STORE.set(new HashMap());
            }
            String key = entity.getClass().getName() + ":" + entity.getId();
            EntityState state = (EntityState)((Map)STORE.get()).get(key);
            if (state == null) {
                state = new EntityState();
                state.entity = entity;
                state.values = values;
                state.oldValues = oldValues;
                ((Map)STORE.get()).put(key, state);
            } else {
                state.values.putAll(values);
            }
        }
    }
}

