/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.inject.Inject;

public class AuditableRunner {
    static ThreadLocal<User> batchUser = new ThreadLocal();
    private static final String DEFAULT_BATCH_USER = "admin";
    private UserRepository users;

    @Inject
    public AuditableRunner(UserRepository users) {
        this.users = users;
    }

    public void run(final Runnable job) {
        try {
            this.run(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    job.run();
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(Callable<T> job) throws Exception {
        Preconditions.checkNotNull(job);
        Preconditions.checkNotNull((Object)this.users);
        User user = AuthUtils.getUser();
        if (user == null) {
            user = this.users.findByCode(DEFAULT_BATCH_USER);
        }
        batchUser.set(user);
        try {
            T t = job.call();
            return t;
        }
        finally {
            batchUser.remove();
        }
    }
}

