/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthObserver;
import com.axelor.auth.AuthRealm;
import com.axelor.auth.AuthSecurity;
import com.axelor.auth.AuthWebModule;
import com.axelor.auth.ldap.AuthLdapModule;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.axelor.auth.pac4j.AuthPac4jModuleCas;
import com.axelor.auth.pac4j.AuthPac4jModuleForm;
import com.axelor.auth.pac4j.AuthPac4jModuleOAuth;
import com.axelor.auth.pac4j.AuthPac4jModuleOidc;
import com.axelor.auth.pac4j.AuthPac4jModuleSaml;
import com.axelor.auth.pac4j.AuthPac4jObserverCreate;
import com.axelor.auth.pac4j.AuthPac4jObserverLink;
import com.axelor.db.JpaSecurity;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.mgt.SecurityManager;

public class AuthModule
extends AbstractModule {
    private ServletContext context;

    public AuthModule() {
    }

    public AuthModule(ServletContext context) {
        this.context = context;
    }

    protected final void configure() {
        this.bind(JpaSecurity.class).toProvider(AuthSecurity.class);
        if (this.context == null) {
            this.install((Module)new MyShiroModule());
            return;
        }
        this.bind(AuthObserver.class);
        if (AuthLdapModule.isEnabled()) {
            this.install((Module)new AuthLdapModule(this.context));
            return;
        }
        if (AuthPac4jModule.isEnabled()) {
            String userProvisioning;
            AppSettings settings = AppSettings.get();
            switch (userProvisioning = settings.get("auth.user.provisioning", "create")) {
                case "create": {
                    this.bind(AuthPac4jObserverCreate.class);
                    break;
                }
                case "link": {
                    this.bind(AuthPac4jObserverLink.class);
                    break;
                }
            }
            if (AuthPac4jModuleOidc.isEnabled()) {
                this.install((Module)new AuthPac4jModuleOidc(this.context));
                return;
            }
            if (AuthPac4jModuleOAuth.isEnabled()) {
                this.install((Module)new AuthPac4jModuleOAuth(this.context));
                return;
            }
            if (AuthPac4jModuleSaml.isEnabled()) {
                this.install((Module)new AuthPac4jModuleSaml(this.context));
                return;
            }
            if (AuthPac4jModuleCas.isEnabled()) {
                this.install((Module)new AuthPac4jModuleCas(this.context));
                return;
            }
            this.install((Module)new AuthPac4jModuleForm(this.context));
            return;
        }
        this.install((Module)new AuthWebModule(this.context));
    }

    @Singleton
    public static class Initializer {
        @Inject
        public Initializer(Injector injector) {
            SecurityManager sm = (SecurityManager)injector.getInstance(SecurityManager.class);
            SecurityUtils.setSecurityManager((SecurityManager)sm);
        }
    }

    static final class MyShiroModule
    extends ShiroModule {
        MyShiroModule() {
        }

        protected void configureShiro() {
            this.bindRealm().to(AuthRealm.class);
            this.bind(Initializer.class).asEagerSingleton();
        }
    }
}

