/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthFilter;
import com.axelor.auth.AuthService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.UserAuthenticationInfo;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRealm
extends AuthorizingRealm {
    private static Logger log = LoggerFactory.getLogger(AuthRealm.class);
    private static final String INCORRECT_CREDENTIALS = "Wrong username or password";
    private static final String WRONG_CURRENT_PASSWORD = "Wrong current password";
    private CredentialsMatcher credentialsMatcher = new AuthMatcher();

    public CredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String code = ((UsernamePasswordToken)token).getUsername();
        User user = AuthUtils.getUser(code);
        if (user == null || !AuthUtils.isActive(user)) {
            throw new IncorrectCredentialsException(INCORRECT_CREDENTIALS);
        }
        return new UserAuthenticationInfo(code, user.getPassword(), this.getName(), user);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String code = (String)principals.fromRealm(this.getName()).iterator().next();
        User user = AuthUtils.getUser(code);
        if (user == null) {
            return null;
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Group group = user.getGroup();
        if (group != null) {
            info.addRole(group.getCode());
        }
        return info;
    }

    static class UserExpiredCredentialsException
    extends ExpiredCredentialsException {
        private static final long serialVersionUID = 774688102294116466L;
        private final transient User user;

        public UserExpiredCredentialsException(User user) {
            this.user = user;
        }

        public UserExpiredCredentialsException(User user, String message) {
            super(message);
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }
    }

    public static class AuthMatcher
    extends PasswordMatcher {
        public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
            Object plain = this.getSubmittedPassword(token);
            Object saved = this.getStoredPassword(info);
            AuthService service = AuthService.getInstance();
            if (plain instanceof char[]) {
                plain = new String((char[])plain);
            }
            AuthFilter.UsernamePasswordTokenWithParams userToken = (AuthFilter.UsernamePasswordTokenWithParams)token;
            UserAuthenticationInfo userInfo = (UserAuthenticationInfo)info;
            if (service.match((String)plain, (String)saved) || super.doCredentialsMatch(token, info)) {
                this.processPasswordChange(userToken, userInfo);
                return true;
            }
            if (this.isChangingPassword(userToken)) {
                throw new UserExpiredCredentialsException(userInfo.getUser(), AuthRealm.WRONG_CURRENT_PASSWORD);
            }
            log.error("Password authentication failed for user: {}", token.getPrincipal());
            throw new IncorrectCredentialsException(AuthRealm.INCORRECT_CREDENTIALS);
        }

        private boolean isChangingPassword(AuthFilter.UsernamePasswordTokenWithParams token) {
            String newPassword = token.getCleanParam("newPassword");
            return StringUtils.notBlank((CharSequence)newPassword);
        }

        private void processPasswordChange(AuthFilter.UsernamePasswordTokenWithParams token, UserAuthenticationInfo info) {
            User user = info.getUser();
            if (!user.getForcePasswordChange().booleanValue()) {
                return;
            }
            String newPassword = token.getCleanParam("newPassword");
            if (StringUtils.isBlank((CharSequence)newPassword)) {
                throw new UserExpiredCredentialsException(user);
            }
            JPA.runInTransaction(() -> {
                Beans.get(AuthService.class).changePassword(user, newPassword);
                user.setForcePasswordChange(false);
            });
        }
    }
}

