/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.JpaSecurity;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;

final class AuthResolver {
    AuthResolver() {
    }

    boolean hasAccess(Permission permission, JpaSecurity.AccessType accessType) {
        if (accessType == null) {
            return true;
        }
        switch (accessType) {
            case READ: {
                return permission.getCanRead() == Boolean.TRUE;
            }
            case WRITE: {
                return permission.getCanWrite() == Boolean.TRUE;
            }
            case CREATE: {
                return permission.getCanCreate() == Boolean.TRUE;
            }
            case REMOVE: {
                return permission.getCanRemove() == Boolean.TRUE;
            }
            case EXPORT: {
                return permission.getCanExport() == Boolean.TRUE;
            }
        }
        return false;
    }

    private Set<Permission> filterPermissions(Set<Permission> permissions, String object, JpaSecurity.AccessType type) {
        LinkedHashSet all = Sets.newLinkedHashSet();
        if (permissions == null || permissions.isEmpty()) {
            return all;
        }
        for (Permission permission : permissions) {
            if (!Objects.equal((Object)object, (Object)permission.getObject()) || !this.hasAccess(permission, type)) continue;
            all.add(permission);
        }
        String pkg = object.substring(0, object.lastIndexOf(46)) + ".*";
        for (Permission permission : permissions) {
            if (!Objects.equal((Object)pkg, (Object)permission.getObject()) || !this.hasAccess(permission, type)) continue;
            all.add(permission);
        }
        return all;
    }

    public Set<Permission> resolve(User user, String object, JpaSecurity.AccessType type) {
        Set<Permission> all = this.filterPermissions(user.getPermissions(), object, type);
        if (user.getRoles() != null) {
            for (Role role : user.getRoles()) {
                all.addAll(this.filterPermissions(role.getPermissions(), object, type));
            }
        }
        if (user.getGroup() != null) {
            all.addAll(this.filterPermissions(user.getGroup().getPermissions(), object, type));
        }
        if (user.getGroup() != null && user.getGroup().getRoles() != null) {
            for (Role role : user.getGroup().getRoles()) {
                all.addAll(this.filterPermissions(role.getPermissions(), object, type));
            }
        }
        return all;
    }
}

