/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthUtils;
import com.axelor.db.JpaSecurity;

public class AuthSecurityException
extends RuntimeException {
    private static final long serialVersionUID = -794508889899422879L;
    private JpaSecurity.AccessType type;
    private Class<?> model;
    private Long[] ids;

    public AuthSecurityException(JpaSecurity.AccessType type) {
        this(type, null, new Long[0]);
    }

    public AuthSecurityException(JpaSecurity.AccessType type, Class<?> model, Long ... ids) {
        this.type = type;
        this.model = model;
        this.ids = ids;
    }

    public JpaSecurity.AccessType getType() {
        return this.type;
    }

    public Class<?> getModel() {
        return this.model;
    }

    public Long[] getIds() {
        return this.ids;
    }

    @Override
    public String getMessage() {
        if (this.model == null || AuthUtils.getUser() == null || !AuthUtils.isTechnicalStaff(AuthUtils.getUser())) {
            return this.type.getMessage();
        }
        StringBuilder builder = new StringBuilder(this.type.getMessage()).append("[").append(this.model.getName());
        if (this.ids.length > 0) {
            builder.append("#");
            int n = Math.min(5, this.ids.length);
            for (int i = 0; i < n; ++i) {
                builder.append(this.ids[i]);
                if (i >= n - 1) continue;
                builder.append(",");
            }
            if (this.ids.length > 5) {
                builder.append(",...");
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

