/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Permission;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaPermission;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="AUTH_ROLE")
public class Role
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_ROLE_SEQ")
    @SequenceGenerator(name="AUTH_ROLE_SEQ", sequenceName="AUTH_ROLE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NotNull
    @Column(unique=true)
    private String name;
    private String description;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="roles", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaMenu> menus;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Permission> permissions;
    @Widget(title="Permissions (fields)")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaPermission> metaPermissions;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<MetaMenu> getMenus() {
        return this.menus;
    }

    public void setMenus(Set<MetaMenu> menus) {
        this.menus = menus;
    }

    public void addMenu(MetaMenu item) {
        if (this.getMenus() == null) {
            this.setMenus(new HashSet<MetaMenu>());
        }
        this.getMenus().add(item);
    }

    public void removeMenu(MetaMenu item) {
        if (this.getMenus() == null) {
            return;
        }
        this.getMenus().remove(item);
    }

    public void clearMenus() {
        if (this.getMenus() != null) {
            this.getMenus().clear();
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission item) {
        if (this.getPermissions() == null) {
            this.setPermissions(new HashSet<Permission>());
        }
        this.getPermissions().add(item);
    }

    public void removePermission(Permission item) {
        if (this.getPermissions() == null) {
            return;
        }
        this.getPermissions().remove(item);
    }

    public void clearPermissions() {
        if (this.getPermissions() != null) {
            this.getPermissions().clear();
        }
    }

    public Set<MetaPermission> getMetaPermissions() {
        return this.metaPermissions;
    }

    public void setMetaPermissions(Set<MetaPermission> metaPermissions) {
        this.metaPermissions = metaPermissions;
    }

    public void addMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            this.setMetaPermissions(new HashSet<MetaPermission>());
        }
        this.getMetaPermissions().add(item);
    }

    public void removeMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            return;
        }
        this.getMetaPermissions().remove(item);
    }

    public void clearMetaPermissions() {
        if (this.getMetaPermissions() != null) {
            this.getMetaPermissions().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(2552982, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription()).omitNullValues().toString();
    }
}

