/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaPermission;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Cacheable
@Table(name="AUTH_USER", indexes={@Index(columnList="name"), @Index(columnList="group_id")})
public class User
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_USER_SEQ")
    @SequenceGenerator(name="AUTH_USER_SEQ", sequenceName="AUTH_USER_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Login")
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @NotNull
    @Size(min=2)
    private String name;
    @Widget(password=true)
    @NotNull
    @Size(min=4)
    private String password;
    @Widget(title="Last password update date")
    private LocalDateTime passwordUpdatedOn;
    @Widget(help="Force the user to change their password at next login.")
    private Boolean forcePasswordChange = Boolean.FALSE;
    @Widget(image=true, title="Photo", help="Max size 4MB.")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] image;
    private String email;
    @Widget(selection="select.language")
    private String language;
    private String homeAction;
    private String theme;
    @Widget(help="Whether to use tabbed ui.")
    private Boolean singleTab = Boolean.FALSE;
    @Widget(help="Whether to show help messages.")
    private Boolean noHelp = Boolean.FALSE;
    @Widget(title="Block the user", help="Block the user for an indefinite period.")
    private Boolean blocked = Boolean.FALSE;
    @Widget(help="Activate the user from the specified date.")
    private LocalDate activateOn;
    @Widget(help="Disable the user from the specified date.")
    private LocalDate expiresOn;
    @JoinColumn(name="group_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Group group;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Permission> permissions;
    @Widget(title="Permissions (fields)")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaPermission> metaPermissions;

    public User() {
    }

    public User(String code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public LocalDateTime getPasswordUpdatedOn() {
        return this.passwordUpdatedOn;
    }

    public void setPasswordUpdatedOn(LocalDateTime passwordUpdatedOn) {
        this.passwordUpdatedOn = passwordUpdatedOn;
    }

    public Boolean getForcePasswordChange() {
        return this.forcePasswordChange == null ? Boolean.FALSE : this.forcePasswordChange;
    }

    public void setForcePasswordChange(Boolean forcePasswordChange) {
        this.forcePasswordChange = forcePasswordChange;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getHomeAction() {
        return this.homeAction;
    }

    public void setHomeAction(String homeAction) {
        this.homeAction = homeAction;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Boolean getSingleTab() {
        return this.singleTab == null ? Boolean.FALSE : this.singleTab;
    }

    public void setSingleTab(Boolean singleTab) {
        this.singleTab = singleTab;
    }

    public Boolean getNoHelp() {
        return this.noHelp == null ? Boolean.FALSE : this.noHelp;
    }

    public void setNoHelp(Boolean noHelp) {
        this.noHelp = noHelp;
    }

    public Boolean getBlocked() {
        return this.blocked == null ? Boolean.FALSE : this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public LocalDate getActivateOn() {
        return this.activateOn;
    }

    public void setActivateOn(LocalDate activateOn) {
        this.activateOn = activateOn;
    }

    public LocalDate getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(LocalDate expiresOn) {
        this.expiresOn = expiresOn;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet<Role>());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission item) {
        if (this.getPermissions() == null) {
            this.setPermissions(new HashSet<Permission>());
        }
        this.getPermissions().add(item);
    }

    public void removePermission(Permission item) {
        if (this.getPermissions() == null) {
            return;
        }
        this.getPermissions().remove(item);
    }

    public void clearPermissions() {
        if (this.getPermissions() != null) {
            this.getPermissions().clear();
        }
    }

    public Set<MetaPermission> getMetaPermissions() {
        return this.metaPermissions;
    }

    public void setMetaPermissions(Set<MetaPermission> metaPermissions) {
        this.metaPermissions = metaPermissions;
    }

    public void addMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            this.setMetaPermissions(new HashSet<MetaPermission>());
        }
        this.getMetaPermissions().add(item);
    }

    public void removeMetaPermission(MetaPermission item) {
        if (this.getMetaPermissions() == null) {
            return;
        }
        this.getMetaPermissions().remove(item);
    }

    public void clearMetaPermissions() {
        if (this.getMetaPermissions() != null) {
            this.getMetaPermissions().clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(2645995, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("passwordUpdatedOn", (Object)this.getPasswordUpdatedOn()).add("forcePasswordChange", (Object)this.getForcePasswordChange()).add("email", (Object)this.getEmail()).add("language", (Object)this.getLanguage()).add("homeAction", (Object)this.getHomeAction()).add("theme", (Object)this.getTheme()).add("singleTab", (Object)this.getSingleTab()).add("noHelp", (Object)this.getNoHelp()).add("blocked", (Object)this.getBlocked()).omitNullValues().toString();
    }
}

