/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.ldap;

import com.axelor.auth.AuthRealm;
import com.axelor.auth.ldap.AuthLdapService;
import com.axelor.inject.Beans;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthLdapRealm
extends AuthRealm {
    private static Logger log = LoggerFactory.getLogger(AuthLdapRealm.class);
    private CredentialsMatcher credentialsMatcher = new AuthMatcher();

    @Override
    public CredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String code = ((UsernamePasswordToken)token).getUsername();
        String passwd = new String(((UsernamePasswordToken)token).getPassword());
        AuthLdapService service = Beans.get(AuthLdapService.class);
        try {
            service.login(code, passwd);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (AuthenticationException e) {
            log.error("LDAP authentication failed for user: {}", (Object)code);
        }
        return super.doGetAuthenticationInfo(token);
    }

    public static class AuthMatcher
    extends PasswordMatcher {
        public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
            Object plain = this.getSubmittedPassword(token);
            AuthLdapService service = Beans.get(AuthLdapService.class);
            if (plain instanceof char[]) {
                plain = new String((char[])plain);
            }
            try {
                return service.login((String)token.getPrincipal(), (String)plain);
            }
            catch (Exception e) {
                log.error("Authentication failed for user: {}", token.getPrincipal());
                return false;
            }
        }
    }
}

