/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.ldap;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthService;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.Query;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.inject.persist.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthLdapService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String LDAP_SERVER_URL = "ldap.server.url";
    public static final String LDAP_AUTH_TYPE = "ldap.auth.type";
    public static final String LDAP_SYSTEM_USER = "ldap.system.user";
    public static final String LDAP_SYSTEM_PASSWORD = "ldap.system.password";
    public static final String LDAP_GROUP_BASE = "ldap.group.base";
    public static final String LDAP_GROUP_OBJECT_CLASS = "ldap.group.object.class";
    public static final String LDAP_GROUP_FILTER = "ldap.group.filter";
    public static final String LDAP_USER_BASE = "ldap.user.base";
    public static final String LDAP_USER_FILTER = "ldap.user.filter";
    public static final String DEFAULT_AUTH_TYPE = "simple";
    private String ldapServerUrl;
    private String ldapAuthType;
    private String ldapSysUser;
    private String ldapSysPassword;
    private String ldapGroupsDn;
    private String ldapUsersDn;
    private String ldapGroupFilter;
    private String ldapUserFilter;
    private String ldapGroupObjectClass;
    private JndiLdapContextFactory factory = new JndiLdapContextFactory();
    @Inject
    private AuthService authService;
    @Inject
    private UserRepository users;
    @Inject
    private GroupRepository groups;

    @Inject
    public AuthLdapService() {
        this(AppSettings.get().getProperties());
    }

    public AuthLdapService(Properties properties) {
        this.ldapServerUrl = properties.getProperty(LDAP_SERVER_URL);
        this.ldapAuthType = properties.getProperty(LDAP_AUTH_TYPE, DEFAULT_AUTH_TYPE);
        this.ldapSysUser = properties.getProperty(LDAP_SYSTEM_USER);
        this.ldapSysPassword = properties.getProperty(LDAP_SYSTEM_PASSWORD);
        this.ldapGroupsDn = properties.getProperty(LDAP_GROUP_BASE);
        this.ldapUsersDn = properties.getProperty(LDAP_USER_BASE);
        this.ldapGroupFilter = properties.getProperty(LDAP_GROUP_FILTER);
        this.ldapUserFilter = properties.getProperty(LDAP_USER_FILTER);
        this.ldapGroupObjectClass = properties.getProperty(LDAP_GROUP_OBJECT_CLASS);
        this.factory.setUrl(this.ldapServerUrl);
        this.factory.setSystemUsername(this.ldapSysUser);
        this.factory.setSystemPassword(this.ldapSysPassword);
        this.factory.setAuthenticationMechanism(this.ldapAuthType);
    }

    public boolean isEnabled() {
        return this.ldapServerUrl != null && !"".equals(this.ldapServerUrl.trim());
    }

    public boolean ldapUserExists(String filter, String code) {
        try {
            return this.search(this.ldapUsersDn, filter, code).hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public boolean ldapGroupExists(String filter, String code) {
        try {
            return this.search(this.ldapGroupsDn, filter, code).hasMore();
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    @Transactional
    public boolean login(String user, String password) throws AuthenticationException {
        if (!this.isEnabled()) {
            throw new IllegalStateException("LDAP is not enabled.");
        }
        try {
            return this.doLogin(user, password);
        }
        catch (NamingException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLogin(String user, String password) throws NamingException {
        block3: {
            NamingEnumeration<?> all = this.search(this.ldapUsersDn, this.ldapUserFilter, user);
            if (!all.hasMore()) {
                throw new NamingException("LDAP user does not exist: " + user);
            }
            if (!all.hasMore()) break block3;
            SearchResult result = (SearchResult)all.next();
            String dn = result.getNameInNamespace();
            LdapContext context = null;
            try {
                context = this.factory.getLdapContext((Object)dn, (Object)password);
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(context);
                throw throwable;
            }
            LdapUtils.closeContext((LdapContext)context);
            this.findOrCreateUser(user, result);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration<?> search(String where, String filter, String user) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        String filterString = filter.replaceAll("\\{0\\}", user);
        LdapContext context = this.factory.getSystemLdapContext();
        try {
            NamingEnumeration<SearchResult> namingEnumeration = context.search(where, filterString, controls);
            return namingEnumeration;
        }
        finally {
            LdapUtils.closeContext((LdapContext)context);
        }
    }

    private User findOrCreateUser(String code, SearchResult result) throws NamingException {
        User user = this.users.findByCode(code);
        if (user != null) {
            return user;
        }
        Attributes attributes = result.getAttributes();
        Attribute cn = attributes.get("cn");
        String name = code;
        try {
            name = (String)cn.get();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        user = new User(code, name);
        user.setPassword(UUID.randomUUID().toString());
        this.authService.encrypt(user);
        try {
            Group group = this.findOrCreateGroup(user);
            user.setGroup(group);
        }
        catch (Exception group) {
            // empty catch block
        }
        try {
            this.createLdapGroups();
        }
        catch (Exception e) {
            this.log.warn("unable to create ldap groups", (Throwable)e);
        }
        return this.users.save(user);
    }

    private Group findOrCreateGroup(User user) throws NamingException {
        SearchResult result;
        Attributes attributes;
        String name;
        Group group = user.getGroup();
        if (group != null) {
            return group;
        }
        NamingEnumeration<?> all = this.search(this.ldapGroupsDn, this.ldapGroupFilter, user.getCode());
        if (all.hasMore() && (group = this.groups.findByCode(name = (String)(attributes = (result = (SearchResult)all.next()).getAttributes()).get("cn").get())) == null) {
            group = new Group(name, name.substring(0, 1).toUpperCase() + name.substring(1));
        }
        if (all.hasMore()) {
            this.log.warn("more then one groups defined.");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadGroup(Group group) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objClass = new BasicAttribute("objectClass");
        objClass.add("top");
        objClass.add(this.ldapGroupObjectClass);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(group.getCode());
        BasicAttribute uniqueMember = new BasicAttribute("uniqueMember");
        uniqueMember.add("uid=admin");
        attrs.put(objClass);
        attrs.put(cn);
        attrs.put(uniqueMember);
        LdapContext context = this.factory.getSystemLdapContext();
        try {
            context.createSubcontext("cn=" + group.getCode() + "," + this.ldapGroupsDn, (Attributes)attrs);
        }
        finally {
            LdapUtils.closeContext((LdapContext)context);
        }
    }

    private void createLdapGroups() throws NamingException {
        if (this.ldapGroupObjectClass == null || "".equals(this.ldapGroupObjectClass.trim())) {
            return;
        }
        HashSet found = Sets.newHashSet();
        NamingEnumeration<?> all = this.search(this.ldapGroupsDn, this.ldapGroupFilter, "*");
        while (all.hasMore()) {
            SearchResult result = (SearchResult)all.next();
            Attributes attributes = result.getAttributes();
            String name = (String)attributes.get("cn").get();
            if (!StringUtils.notBlank((CharSequence)name)) continue;
            found.add(name);
        }
        if (found.isEmpty()) {
            return;
        }
        List<Group> groups = Query.of(Group.class).filter("self.code not in (:names)").bind("names", found).fetch();
        for (Group group : groups) {
            this.uploadGroup(group);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("url", (Object)this.ldapServerUrl).toString();
    }
}

