/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthWebModule;
import com.axelor.auth.pac4j.AuthPac4jListener;
import com.axelor.auth.pac4j.AuthPac4jModuleCas;
import com.axelor.auth.pac4j.AuthPac4jModuleOAuth;
import com.axelor.auth.pac4j.AuthPac4jModuleOidc;
import com.axelor.auth.pac4j.AuthPac4jModuleSaml;
import com.axelor.auth.pac4j.AuthPac4jRealm;
import com.axelor.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.buji.pac4j.context.ShiroSessionStore;
import io.buji.pac4j.engine.ShiroCallbackLogic;
import io.buji.pac4j.engine.ShiroSecurityLogic;
import io.buji.pac4j.filter.CallbackFilter;
import io.buji.pac4j.filter.LogoutFilter;
import io.buji.pac4j.filter.SecurityFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.FormClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthPac4jModule
extends AuthWebModule {
    public static final String CONFIG_AUTH_CALLBACK_URL = "auth.callback.url";
    public static final String CONFIG_AUTH_USER_PROVISIONING = "auth.user.provisioning";
    public static final String CONFIG_AUTH_USER_DEFAULT_GROUP = "auth.user.default.group";
    public static final String CONFIG_AUTH_USER_PRINCIPAL_ATTRIBUTE = "auth.user.principal.attribute";
    public static final String CONFIG_AUTH_LOGOUT_URL = "auth.logout.url";
    public static final String CONFIG_AUTH_LOGOUT_URL_PATTERN = "auth.logout.url.pattern";
    public static final String CONFIG_AUTH_LOGOUT_LOCAL = "auth.logout.local";
    public static final String CONFIG_AUTH_LOGOUT_CENTRAL = "auth.logout.central";
    protected static final String ROLE_HAS_USER = "_ROLE_HAS_USER";
    private static final String HASH_LOCATION_PARAMETER = "hash_location";
    private List<Client> clientList = new ArrayList<Client>();
    private static final Set<String> centralClientNames = new LinkedHashSet<String>();
    private static final Map<String, Map<String, String>> clientInfo = new HashMap<String, Map<String, String>>();
    private static String callbackUrl;
    private static boolean absCallbackUrlRequired;
    private static String logoutUrl;
    private static final Logger logger;

    public AuthPac4jModule(ServletContext servletContext) {
        super(servletContext);
        logger.info("Loading pac4j: {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    @Nullable
    public static Map<String, String> getClientInfo(String clientName) {
        return clientInfo.get(clientName);
    }

    protected static void setClientInfo(String clientName, Map<String, String> info) {
        clientInfo.put(clientName, info);
    }

    @Override
    protected void configureAuth() {
        this.configureClients();
        Multibinder listenerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), AuthenticationListener.class);
        listenerMultibinder.addBinding().to(AuthPac4jListener.class);
        this.bind(ConfigSupplier.class);
        this.bindRealm().to(AuthPac4jRealm.class);
        this.addFilterChain("/logout", Key.get(AxelorLogoutFilter.class));
        this.addFilterChain("/callback", Key.get(AxelorCallbackFilter.class));
        this.addFilterChain("/**", Key.get(AxelorSecurityFilter.class));
    }

    protected abstract void configureClients();

    protected void addClient(FormClient client) {
        this.clientList.add(0, (Client)client);
        logger.info("Added local client: {}", (Object)client.getName());
    }

    protected void addClient(Client<?, ?> client) {
        this.clientList.add(client);
        centralClientNames.add(client.getName());
        logger.info("Added central client: {}", (Object)client.getName());
    }

    public static Set<String> getCentralClients() {
        return centralClientNames;
    }

    @Provides
    public List<Client> getClientList() {
        return this.clientList;
    }

    public static String getRelativeBaseURL() {
        String base = AppSettings.get().getBaseURL();
        return URI.create(base).getPath();
    }

    public static String getCallbackUrl() {
        if (callbackUrl == null) {
            if (AuthPac4jModule.isEnabled()) {
                AppSettings settings = AppSettings.get();
                callbackUrl = settings.get(CONFIG_AUTH_CALLBACK_URL, null);
                if (StringUtils.isBlank((CharSequence)callbackUrl) && AuthPac4jModuleCas.isEnabled()) {
                    callbackUrl = settings.get("auth.cas.service", null);
                }
                if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                    String base = AppSettings.get().getBaseURL();
                    if (!absCallbackUrlRequired) {
                        base = URI.create(base).getPath();
                    }
                    callbackUrl = base + "/callback";
                }
            } else {
                callbackUrl = "";
            }
        }
        return callbackUrl;
    }

    public static void requireAbsCallbackUrl() {
        absCallbackUrlRequired = true;
    }

    public static String getLogoutUrl() {
        if (logoutUrl == null) {
            AppSettings settings = AppSettings.get();
            logoutUrl = settings.get(CONFIG_AUTH_LOGOUT_URL, null);
            if (StringUtils.isBlank((CharSequence)logoutUrl)) {
                String string = logoutUrl = AuthPac4jModuleCas.isEnabled() ? settings.get("auth.cas.logout.url", AuthPac4jModule.getRelativeBaseURL()) : AuthPac4jModule.getRelativeBaseURL();
            }
            if (StringUtils.isBlank((CharSequence)logoutUrl)) {
                logoutUrl = ".";
            }
        }
        return logoutUrl;
    }

    public static boolean isEnabled() {
        return AuthPac4jModuleOidc.isEnabled() || AuthPac4jModuleOAuth.isEnabled() || AuthPac4jModuleSaml.isEnabled() || AuthPac4jModuleCas.isEnabled();
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        bind.to(DefaultWebSecurityManager.class);
    }

    @Provides
    protected DefaultWebSecurityManager provideDefaultSecurityManager(Collection<Realm> realms, Set<AuthenticationListener> authenticationListeners) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager(realms);
        ModularRealmAuthenticator authenticator = new ModularRealmAuthenticator();
        authenticator.setRealms(realms);
        authenticator.setAuthenticationListeners(authenticationListeners);
        securityManager.setAuthenticator((Authenticator)authenticator);
        return securityManager;
    }

    protected static boolean isXHR(WebContext context) {
        return context instanceof J2EContext && AuthPac4jModule.isXHR(((J2EContext)context).getRequest());
    }

    protected static boolean isXHR(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With")) || "application/json".equals(request.getHeader("Accept")) || "application/json".equals(request.getHeader("Content-Type"));
    }

    static {
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private static class AxelorSecurityFilter
    extends SecurityFilter {
        @Inject
        public AxelorSecurityFilter(ConfigSupplier configSupplier) {
            Config config = configSupplier.get();
            this.setConfig(config);
            this.setAuthorizers("auth");
            String clientNames = config.getClients().getClients().stream().map(Client::getName).collect(Collectors.joining(","));
            this.setClients(clientNames);
            this.setSecurityLogic((SecurityLogic)new ShiroSecurityLogic<Object, J2EContext>(){

                protected void saveRequestedUrl(J2EContext context, List<Client> currentClients) {
                    String clientName;
                    String hashLocation = context.getRequestParameter(AuthPac4jModule.HASH_LOCATION_PARAMETER);
                    if (StringUtils.notBlank((CharSequence)hashLocation)) {
                        context.getSessionStore().set((WebContext)context, AuthPac4jModule.HASH_LOCATION_PARAMETER, (Object)hashLocation);
                    }
                    if (StringUtils.isBlank((CharSequence)(clientName = context.getRequestParameter("client_name"))) || currentClients.size() != 1 || !centralClientNames.contains(currentClients.get(0).getName())) {
                        super.saveRequestedUrl((WebContext)context, currentClients);
                    }
                }
            });
        }
    }

    private static class AxelorCallbackFilter
    extends CallbackFilter {
        @Inject
        public AxelorCallbackFilter(ConfigSupplier configSupplier) {
            Config config = configSupplier.get();
            this.setConfig(config);
            AppSettings settings = AppSettings.get();
            String defaultUrl = settings.getBaseURL();
            if (StringUtils.notBlank((CharSequence)defaultUrl)) {
                this.setDefaultUrl(defaultUrl);
            }
            this.setDefaultClient(((Client)config.getClients().getClients().get(0)).getName());
            this.setCallbackLogic((CallbackLogic)new ShiroCallbackLogic<Object, J2EContext>(){

                protected HttpAction redirectToOriginallyRequestedUrl(J2EContext context, String defaultUrl) {
                    String hashLocation;
                    if (AuthPac4jModule.isXHR((WebContext)context)) {
                        return HttpAction.status((int)200, (WebContext)context);
                    }
                    String requestedUrl = (String)context.getSessionStore().get((WebContext)context, "pac4jRequestedUrl");
                    String redirectUrl = defaultUrl;
                    if (StringUtils.notBlank((CharSequence)requestedUrl)) {
                        context.getSessionStore().set((WebContext)context, "pac4jRequestedUrl", null);
                        redirectUrl = requestedUrl;
                    }
                    if (StringUtils.isBlank((CharSequence)(hashLocation = context.getRequestParameter(AuthPac4jModule.HASH_LOCATION_PARAMETER)))) {
                        hashLocation = (String)context.getSessionStore().get((WebContext)context, AuthPac4jModule.HASH_LOCATION_PARAMETER);
                    }
                    if (StringUtils.notBlank((CharSequence)hashLocation)) {
                        redirectUrl = redirectUrl + hashLocation;
                    }
                    this.logger.debug("redirectUrl: {}", (Object)redirectUrl);
                    return HttpAction.redirect((WebContext)context, (String)redirectUrl);
                }
            });
        }
    }

    private static class AxelorLogoutFilter
    extends LogoutFilter {
        @Inject
        public AxelorLogoutFilter(ConfigSupplier configSupplier) {
            AppSettings settings = AppSettings.get();
            String logoutUrlPattern = settings.get(AuthPac4jModule.CONFIG_AUTH_LOGOUT_URL_PATTERN, null);
            boolean localLogout = settings.getBoolean(AuthPac4jModule.CONFIG_AUTH_LOGOUT_LOCAL, true);
            boolean centralLogout = settings.getBoolean(AuthPac4jModule.CONFIG_AUTH_LOGOUT_CENTRAL, false);
            Config config = configSupplier.get();
            this.setConfig(config);
            this.setDefaultUrl(AuthPac4jModule.getLogoutUrl());
            this.setLogoutUrlPattern(logoutUrlPattern);
            this.setLocalLogout(localLogout);
            this.setCentralLogout(centralLogout);
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            CommonHelper.assertNotNull((String)"logoutLogic", (Object)this.getLogoutLogic());
            CommonHelper.assertNotNull((String)"config", (Object)this.getConfig());
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            SessionStore sessionStore = this.getConfig().getSessionStore();
            J2EContext context = new J2EContext(request, response, (SessionStore)(sessionStore != null ? sessionStore : ShiroSessionStore.INSTANCE));
            this.getLogoutLogic().perform((WebContext)context, this.getConfig(), (HttpActionAdapter)J2ENopHttpActionAdapter.INSTANCE, this.getDefaultUrl(), this.getLogoutUrlPattern(), this.getLocalLogout(), Boolean.valueOf(true), this.getCentralLogout());
        }
    }

    @Singleton
    private static class ConfigSupplier
    implements Supplier<Config> {
        private static Config config;

        @Inject
        public ConfigSupplier(List<Client> clientList) {
            if (config != null) {
                return;
            }
            Clients clients = new Clients(AuthPac4jModule.getCallbackUrl(), clientList);
            RequireAnyRoleAuthorizer authorizer = new RequireAnyRoleAuthorizer(new String[]{AuthPac4jModule.ROLE_HAS_USER});
            config = new Config(clients, (Map)ImmutableMap.of((Object)"auth", (Object)authorizer));
        }

        @Override
        public Config get() {
            return config;
        }
    }
}

