/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModule;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletContext;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.client.direct.DirectCasClient;
import org.pac4j.cas.client.direct.DirectCasProxyClient;
import org.pac4j.cas.client.rest.CasRestBasicAuthClient;
import org.pac4j.cas.client.rest.CasRestFormClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.Client;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPac4jModuleCas
extends AuthPac4jModule {
    public static final String CONFIG_CAS_LOGIN_URL = "auth.cas.login.url";
    public static final String CONFIG_CAS_PREFIX_URL = "auth.cas.prefix.url";
    public static final String CONFIG_CAS_PROTOCOL = "auth.cas.protocol";
    public static final String CONFIG_CAS_ENCODING = "auth.cas.encoding";
    public static final String CONFIG_CAS_RENEW = "auth.cas.renew";
    public static final String CONFIG_CAS_GATEWAY = "auth.cas.gateway";
    public static final String CONFIG_CAS_TIME_TOLERANCE = "auth.cas.time.tolerance";
    public static final String CONFIG_CAS_URL_RESOLVER_CLASS = "auth.cas.url.resolver.class";
    public static final String CONFIG_CAS_DEFAULT_TICKET_VALIDATOR_CLASS = "auth.cas.default.ticket.validator.class";
    public static final String CONFIG_CAS_PROXY_SUPPORT = "auth.cas.proxy.support";
    public static final String CONFIG_CAS_LOGOUT_HANDLER_CLASS = "auth.cas.logout.handler.class";
    public static final String CONFIG_CAS_CLIENT_TYPE = "auth.cas.client.type";
    public static final String CONFIG_CAS_SERVICE_URL = "auth.cas.service.url";
    public static final String CONFIG_CAS_USERNAME_PARAMETER = "auth.cas.username.parameter";
    public static final String CONFIG_CAS_PASSWORD_PARAMETER = "auth.cas.password.parameter";
    public static final String CONFIG_CAS_HEADER_NAME = "auth.cas.header.name";
    public static final String CONFIG_CAS_PREFIX_HEADER = "auth.cas.prefix.header";
    public static final String CONFIG_CAS_SERVER_PREFIX_URL = "auth.cas.server.url.prefix";
    public static final String CONFIG_CAS_SERVICE = "auth.cas.service";
    public static final String CONFIG_CAS_LOGOUT_URL = "auth.cas.logout.url";
    public static final String CONFIG_CAS_ATTRS_USER_NAME = "auth.cas.attrs.user.name";
    public static final String CONFIG_CAS_ATTRS_USER_EMAIL = "auth.cas.attrs.user.email";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AuthPac4jModuleCas(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        DirectCasClient client;
        AppSettings settings = AppSettings.get();
        String loginUrl = settings.get(CONFIG_CAS_LOGIN_URL);
        String prefixUrl = settings.get(CONFIG_CAS_PREFIX_URL, settings.get(CONFIG_CAS_SERVER_PREFIX_URL, null));
        String protocol = settings.get(CONFIG_CAS_PROTOCOL, null);
        String encoding = settings.get(CONFIG_CAS_ENCODING, null);
        boolean renew = settings.getBoolean(CONFIG_CAS_RENEW, false);
        boolean gateway = settings.getBoolean(CONFIG_CAS_GATEWAY, false);
        long timeTolerance = settings.getInt(CONFIG_CAS_TIME_TOLERANCE, 1000);
        String urlResolverClass = settings.get(CONFIG_CAS_URL_RESOLVER_CLASS, null);
        String defaultTicketValidatorClass = settings.get(CONFIG_CAS_DEFAULT_TICKET_VALIDATOR_CLASS, null);
        boolean proxySupport = settings.getBoolean(CONFIG_CAS_PROXY_SUPPORT, false);
        String logoutHandlerClass = settings.get(CONFIG_CAS_LOGOUT_HANDLER_CLASS, null);
        String clientType = settings.get(CONFIG_CAS_CLIENT_TYPE, "indirect");
        CasConfiguration casConfig = new CasConfiguration(loginUrl);
        if (prefixUrl != null) {
            casConfig.setPrefixUrl(prefixUrl);
        }
        if (protocol != null) {
            casConfig.setProtocol(CasProtocol.valueOf((String)protocol));
        }
        if (encoding != null) {
            casConfig.setEncoding(encoding);
        }
        casConfig.setRenew(renew);
        casConfig.setGateway(gateway);
        casConfig.setTimeTolerance(timeTolerance);
        if (urlResolverClass != null) {
            try {
                UrlResolver urlResorver = (UrlResolver)Class.forName(urlResolverClass).newInstance();
                casConfig.setUrlResolver(urlResorver);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (defaultTicketValidatorClass != null) {
            try {
                TicketValidator defaultTicketValidator = (TicketValidator)Class.forName(defaultTicketValidatorClass).newInstance();
                casConfig.setDefaultTicketValidator(defaultTicketValidator);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (proxySupport) {
            CasProxyReceptor casProxy = new CasProxyReceptor();
            casConfig.setProxyReceptor(casProxy);
        }
        if (logoutHandlerClass != null) {
            try {
                LogoutHandler logoutHandler = (LogoutHandler)Class.forName(logoutHandlerClass).newInstance();
                casConfig.setLogoutHandler(logoutHandler);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        switch (clientType) {
            case "direct": {
                client = new DirectCasClient(casConfig);
                break;
            }
            case "direct-proxy": {
                String serviceUrl = settings.get(CONFIG_CAS_SERVICE_URL, null);
                client = new DirectCasProxyClient(casConfig, serviceUrl);
                break;
            }
            case "rest-form": {
                String usernameParameter = settings.get(CONFIG_CAS_USERNAME_PARAMETER, "username");
                String passwordParameter = settings.get(CONFIG_CAS_PASSWORD_PARAMETER, "password");
                client = new CasRestFormClient(casConfig, usernameParameter, passwordParameter);
                break;
            }
            case "rest-basic-auth": {
                String headerName = settings.get(CONFIG_CAS_HEADER_NAME, "Authorization");
                String prefixHeader = settings.get(CONFIG_CAS_PREFIX_HEADER, "Basic");
                client = new CasRestBasicAuthClient(casConfig, headerName, prefixHeader.trim() + " ");
                break;
            }
            default: {
                CasClient casClient = new CasClient(casConfig);
                casClient.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
                client = casClient;
            }
        }
        this.addClient((Client<?, ?>)client);
    }

    public static boolean isEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.get(CONFIG_CAS_LOGIN_URL, null) != null;
    }
}

