/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.auth.AuthService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.FormClient;

public class AuthPac4jModuleForm
extends AuthPac4jModule {
    private static final String INCORRECT_CREDENTIALS = "Wrong username or password";
    private static final String WRONG_CURRENT_PASSWORD = "Wrong current password";
    private static final String CHANGE_PASSWORD = "Please change your password.";
    private static final String NEW_PASSWORD_PARAMETER = "newPassword";

    public AuthPac4jModuleForm(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        this.addFormClient();
    }

    @Override
    protected void configureAnon() {
        super.configureAnon();
        this.addFilterChain("/login.jsp", ANON);
        this.addFilterChain("/change-password.jsp", ANON);
    }

    protected void addFormClient() {
        this.addClient(new AxelorFormClient());
    }

    private static class JsonExtractor
    extends FormExtractor {
        public JsonExtractor() {
            super("username", "password");
        }

        public UsernamePasswordCredentials extract(WebContext context) {
            return AuthPac4jModule.isXHR(context) ? this.extractJson(context) : super.extract(context);
        }

        private UsernamePasswordCredentials extractJson(WebContext context) {
            Map data;
            try {
                data = (Map)new ObjectMapper().readValue(context.getRequestContent(), Map.class);
            }
            catch (IOException e) {
                return null;
            }
            String username = (String)data.get("username");
            String password = (String)data.get("password");
            if (username == null || password == null) {
                return null;
            }
            return new UsernamePasswordCredentials(username, password);
        }
    }

    private static class AxelorAjaxRequestResolver
    extends DefaultAjaxRequestResolver {
        private AxelorAjaxRequestResolver() {
        }

        public boolean isAjax(WebContext context) {
            return super.isAjax(context) || AuthPac4jModule.isXHR(context);
        }

        public RedirectAction buildAjaxResponse(String url, WebContext context) {
            if (this.isAjax(context) && StringUtils.notBlank((CharSequence)url) && url.equals("login.jsp")) {
                throw HttpAction.unauthorized((WebContext)context);
            }
            return super.buildAjaxResponse(url, context);
        }
    }

    private static class AxelorFormAuthenticator
    implements Authenticator<UsernamePasswordCredentials> {
        private AxelorFormAuthenticator() {
        }

        public void validate(UsernamePasswordCredentials credentials, WebContext context) {
            if (credentials == null) {
                throw new CredentialsException("No credentials");
            }
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
                throw new CredentialsException(AuthPac4jModuleForm.INCORRECT_CREDENTIALS);
            }
            User user = AuthUtils.getUser(username);
            if (user == null) {
                throw new CredentialsException(AuthPac4jModuleForm.INCORRECT_CREDENTIALS);
            }
            AuthService authService = AuthService.getInstance();
            String newPassword = context.getRequestParameter(AuthPac4jModuleForm.NEW_PASSWORD_PARAMETER);
            if (!authService.match(password, user.getPassword())) {
                if (StringUtils.isBlank((CharSequence)newPassword)) {
                    throw new CredentialsException(AuthPac4jModuleForm.INCORRECT_CREDENTIALS);
                }
                throw new CredentialsException(AuthPac4jModuleForm.WRONG_CURRENT_PASSWORD);
            }
            if (user.getForcePasswordChange().booleanValue()) {
                if (StringUtils.isBlank((CharSequence)newPassword)) {
                    throw new CredentialsException(AuthPac4jModuleForm.CHANGE_PASSWORD);
                }
                JPA.runInTransaction(() -> {
                    Beans.get(AuthService.class).changePassword(user, newPassword);
                    user.setForcePasswordChange(false);
                });
            }
            CommonProfile profile = new CommonProfile();
            profile.setId(username);
            profile.addAttribute("username", (Object)username);
            credentials.setUserProfile(profile);
        }
    }

    private static class AxelorFormClient
    extends FormClient {
        public AxelorFormClient() {
            this.defaultAuthenticator(new AxelorFormAuthenticator());
            this.setCredentialsExtractor((CredentialsExtractor)new JsonExtractor());
            this.setAjaxRequestResolver((AjaxRequestResolver)new AxelorAjaxRequestResolver());
        }

        protected void clientInit() {
            String baseUrl = AuthPac4jModule.getRelativeBaseURL();
            String loginUrl = baseUrl + "/login.jsp";
            this.setLoginUrl(loginUrl);
            super.clientInit();
        }

        protected UsernamePasswordCredentials retrieveCredentials(WebContext context) {
            UsernamePasswordCredentials credentials;
            CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
            CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
            String username = context.getRequestParameter(this.getUsernameParameter());
            try {
                credentials = (UsernamePasswordCredentials)this.getCredentialsExtractor().extract(context);
                this.logger.debug("usernamePasswordCredentials: {}", (Object)credentials);
                if (credentials == null) {
                    throw this.handleInvalidCredentials(context, username, "Username and password cannot be blank -> return to the form with error", "missing_field");
                }
                if (username == null) {
                    username = credentials.getUsername();
                }
                this.getAuthenticator().validate((Credentials)credentials, context);
            }
            catch (CredentialsException e) {
                throw this.handleInvalidCredentials(context, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((Exception)((Object)e)));
            }
            return credentials;
        }

        protected String computeErrorMessage(Exception e) {
            return e.getMessage();
        }

        protected HttpAction handleInvalidCredentials(WebContext context, String username, String message, String errorMessage) {
            if (AuthPac4jModuleForm.CHANGE_PASSWORD.equals(errorMessage) || StringUtils.notBlank((CharSequence)context.getRequestParameter(AuthPac4jModuleForm.NEW_PASSWORD_PARAMETER))) {
                String redirectionUrl = CommonHelper.addParameter((String)"change-password.jsp", (String)this.getUsernameParameter(), (String)username);
                redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)"error", (String)errorMessage);
                return HttpAction.redirect((WebContext)context, (String)redirectionUrl);
            }
            this.logger.error("Password authentication failed for user: {}", (Object)username);
            return super.handleInvalidCredentials(context, username, message, errorMessage);
        }
    }
}

