/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModuleForm;
import com.axelor.common.StringUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.pac4j.core.client.Client;

public abstract class AuthPac4jModuleMultiClient
extends AuthPac4jModuleForm {
    public AuthPac4jModuleMultiClient(ServletContext servletContext) {
        super(servletContext);
    }

    protected void addFormClientIfNotExclusive(Map<String, Map<String, String>> allSettings) {
        if (allSettings.size() == 1 && allSettings.values().iterator().next().getOrDefault("exclusive", "false").equals("true")) {
            return;
        }
        this.addFormClient();
    }

    protected void addCentralClients(Map<String, Map<String, String>> allSettings, Map<String, Function<Map<String, String>, Client<?, ?>>> providers) {
        for (Map.Entry<String, Map<String, String>> entry : allSettings.entrySet()) {
            String provider = entry.getKey();
            Map<String, String> settings = entry.getValue();
            Function<Map<String, String>, Client<?, ?>> setup = providers.get(provider);
            Client<?, ?> client = setup != null ? setup.apply(settings) : this.setupGeneric(settings, provider);
            this.addClient(client);
        }
    }

    protected abstract Client<?, ?> setupGeneric(Map<String, String> var1, String var2);

    protected static Map<String, Map<String, String>> getAuthSettings(String prefix) {
        LinkedHashMap<String, Map<String, String>> all = new LinkedHashMap<String, Map<String, String>>();
        AppSettings settings = AppSettings.get();
        for (String key : settings.getProperties().stringPropertyNames()) {
            String[] parts;
            if (!key.startsWith(prefix) || (parts = key.substring(prefix.length()).split("\\.", 2)).length <= 1) continue;
            String provider = parts[0];
            String config = parts[1];
            String value = settings.get(key);
            if (!StringUtils.notBlank((CharSequence)value)) continue;
            Map map = all.computeIfAbsent(provider, k -> new HashMap());
            map.put(config, value);
        }
        return all;
    }
}

