/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.auth.pac4j.AuthPac4jModuleMultiClient;
import com.axelor.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.pac4j.core.client.Client;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WechatClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.YahooClient;

public class AuthPac4jModuleOAuth
extends AuthPac4jModuleMultiClient {
    private static final Map<String, Map<String, String>> allSettings = AuthPac4jModuleOAuth.getAuthSettings("auth.oauth.");
    private final Map<String, Function<Map<String, String>, Client<?, ?>>> providers = ImmutableMap.builder().put((Object)"google", this::setupGoogle).put((Object)"facebook", this::setupFacebook).put((Object)"twitter", this::setupTwitter).put((Object)"yahoo", this::setupYahoo).put((Object)"linkedin", this::setupLinkedIn).put((Object)"windowslive", this::setupWindowsLive).put((Object)"wechat", this::setupWeChat).put((Object)"github", this::setupGitHub).build();

    public AuthPac4jModuleOAuth(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        this.addFormClientIfNotExclusive(allSettings);
        this.addCentralClients(allSettings, this.providers);
    }

    @Override
    protected Client<?, ?> setupGeneric(Map<String, String> settings, String providerName) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String authUrl = settings.get("auth.url");
        String tokenUrl = settings.get("token.url");
        String profileAttrsSetting = settings.get("profile.attrs");
        String name = settings.getOrDefault("name", providerName);
        String title = settings.getOrDefault("title", "OAuth 2.0");
        String icon = settings.getOrDefault("icon", "img/signin/oauth.svg");
        GenericOAuth20Client client = new GenericOAuth20Client();
        client.setName(name);
        client.setKey(key);
        client.setSecret(secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        if (StringUtils.notBlank((CharSequence)authUrl)) {
            client.setAuthUrl(authUrl);
        }
        if (StringUtils.notBlank((CharSequence)tokenUrl)) {
            client.setTokenUrl(tokenUrl);
        }
        if (StringUtils.notBlank((CharSequence)profileAttrsSetting)) {
            HashMap<String, String> profileAttrsMap = new HashMap<String, String>();
            for (String item : profileAttrsSetting.split("\\s*,\\s*")) {
                String[] entry = item.split("\\s*:\\s*");
                if (entry.length <= 1) continue;
                String attr = entry[0];
                String value = entry[1];
                profileAttrsMap.put(attr, value);
            }
            client.setProfileAttrs(profileAttrsMap);
        }
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupGoogle(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Google");
        String icon = settings.getOrDefault("icon", "img/signin/google.svg");
        Google2Client client = new Google2Client(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupFacebook(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Facebook");
        String icon = settings.getOrDefault("icon", "img/signin/facebook.svg");
        FacebookClient client = new FacebookClient(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupTwitter(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Twitter");
        String icon = settings.getOrDefault("icon", "img/signin/twitter.svg");
        boolean includeEmail = settings.getOrDefault("include.email", "true").equals("true");
        TwitterClient client = new TwitterClient(key, secret, includeEmail);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupYahoo(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Yahoo!");
        String icon = settings.getOrDefault("icon", "img/signin/yahoo.svg");
        YahooClient client = new YahooClient(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupLinkedIn(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "LinkedIn");
        String icon = settings.getOrDefault("icon", "img/signin/linkedin.svg");
        LinkedIn2Client client = new LinkedIn2Client(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupWindowsLive(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Windows Live");
        String icon = settings.getOrDefault("icon", "img/signin/microsoft.svg");
        WindowsLiveClient client = new WindowsLiveClient(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupWeChat(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "WeChat");
        String icon = settings.getOrDefault("icon", "img/signin/wechat.svg");
        WechatClient client = new WechatClient(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupGitHub(Map<String, String> settings) {
        String key = settings.get("key");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "GitHub");
        String icon = settings.getOrDefault("icon", "img/signin/github.svg");
        GitHubClient client = new GitHubClient(key, secret);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOAuth.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    public static boolean isEnabled() {
        return !allSettings.isEmpty();
    }
}

