/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.axelor.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;

public class AuthPac4jModuleSaml
extends AuthPac4jModule {
    public static final String CONFIG_SAML_KEYSTORE_PATH = "auth.saml.keystore.path";
    public static final String CONFIG_SAML_KEYSTORE_PASSWORD = "auth.saml.keystore.password";
    public static final String CONFIG_SAML_PRIVATE_KEY_PASSWORD = "auth.saml.private.key.password";
    public static final String CONFIG_SAML_IDENTITY_PROVIDER_METADATA_PATH = "auth.saml.identity.provider.metadata.path";
    public static final String CONFIG_SAML_MAXIMUM_AUTHENTICATION_LIFETIME = "auth.saml.maximum.authentication.lifetime";
    public static final String CONFIG_SAML_SERVICE_PROVIDER_ENTITY_ID = "auth.saml.service.provider.entity.id";
    public static final String CONFIG_SAML_SERVICE_PROVIDER_METADATA_PATH = "auth.saml.service.provider.metadata.path";
    public static final String CONFIG_SAML_FORCE_AUTH = "auth.saml.force.auth";
    public static final String CONFIG_SAML_PASSIVE = "auth.saml.passive";
    public static final String CONFIG_SAML_AUTHN_REQUEST_BINDING_TYPE = "auth.saml.authn.request.binding.type";
    public static final String CONFIG_SAML_USE_NAME_QUALIFIER = "auth.saml.use.name.qualifier";
    public static final String CONFIG_SAML_ATTRIBUTE_CONSUMING_SERVICE_INDEX = "auth.saml.attribute.consuming.service.index";
    public static final String CONFIG_SAML_ASSERTION_CONSUMER_SERVICE_INDEX = "auth.saml.assertion.consumer.service.index";
    public static final String CONFIG_SAML_BLACKLISTED_SIGNATURE_SIGNING_ALGORITHMS = "auth.saml.blacklisted.signature.signing.algorithms";
    public static final String CONFIG_SAML_SIGNATURE_ALGORITHMS = "auth.saml.signature.algorithms";
    public static final String CONFIG_SAML_SIGNATURE_REFERENCE_DIGEST_METHODS = "auth.saml.signature.reference.digest.methods";
    public static final String CONFIG_SAML_SIGNATURE_CANONICALIZATION_ALGORITHM = "auth.saml.signature.canonicalization.algorithm";
    public static final String CONFIG_SAML_WANTS_ASSERTIONS_SIGNED = "auth.saml.wants.assertions.signed";
    public static final String CONFIG_SAML_AUTHN_REQUEST_SIGNED = "auth.saml.authn.request.signed";
    private static final Map<String, String> authnRequestBindingTypes = ImmutableMap.of((Object)"SAML2_POST_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)"SAML2_POST_SIMPLE_SIGN_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", (Object)"SAML2_REDIRECT_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");

    public AuthPac4jModuleSaml(ServletContext servletContext) {
        super(servletContext);
        AuthPac4jModule.requireAbsCallbackUrl();
    }

    @Override
    protected void configureClients() {
        AppSettings settings = AppSettings.get();
        String keystorePath = settings.get(CONFIG_SAML_KEYSTORE_PATH);
        String keystorePassword = settings.get(CONFIG_SAML_KEYSTORE_PASSWORD);
        String privateKeyPassword = settings.get(CONFIG_SAML_PRIVATE_KEY_PASSWORD);
        String identityProviderMetadataPath = settings.get(CONFIG_SAML_IDENTITY_PROVIDER_METADATA_PATH);
        int maximumAuthenticationLifetime = settings.getInt(CONFIG_SAML_MAXIMUM_AUTHENTICATION_LIFETIME, -1);
        String serviceProviderEntityId = settings.get(CONFIG_SAML_SERVICE_PROVIDER_ENTITY_ID, null);
        String serviceProviderMetadataPath = settings.get(CONFIG_SAML_SERVICE_PROVIDER_METADATA_PATH, null);
        boolean forceAuth = settings.getBoolean(CONFIG_SAML_FORCE_AUTH, false);
        boolean passive = settings.getBoolean(CONFIG_SAML_PASSIVE, false);
        String authnRequestBindingType = settings.get(CONFIG_SAML_AUTHN_REQUEST_BINDING_TYPE, null);
        boolean useNameQualifier = settings.getBoolean(CONFIG_SAML_USE_NAME_QUALIFIER, false);
        int attributeConsumingServiceIndex = settings.getInt(CONFIG_SAML_ATTRIBUTE_CONSUMING_SERVICE_INDEX, -1);
        int assertionConsumerServiceIndex = settings.getInt(CONFIG_SAML_ASSERTION_CONSUMER_SERVICE_INDEX, -1);
        List<String> blackListedSignatureSigningAlgorithms = settings.getList(CONFIG_SAML_BLACKLISTED_SIGNATURE_SIGNING_ALGORITHMS);
        List<String> signatureAlgorithms = settings.getList(CONFIG_SAML_SIGNATURE_ALGORITHMS);
        List<String> signatureReferenceDigestMethods = settings.getList(CONFIG_SAML_SIGNATURE_REFERENCE_DIGEST_METHODS);
        String signatureCanonicalizationAlgorithm = settings.get(CONFIG_SAML_SIGNATURE_CANONICALIZATION_ALGORITHM, null);
        boolean wantsAssertionsSigned = settings.getBoolean(CONFIG_SAML_WANTS_ASSERTIONS_SIGNED, false);
        boolean authnRequestSigned = settings.getBoolean(CONFIG_SAML_AUTHN_REQUEST_SIGNED, false);
        SAML2Configuration saml2Config = new SAML2Configuration(keystorePath, keystorePassword, privateKeyPassword, identityProviderMetadataPath);
        if (maximumAuthenticationLifetime >= 0) {
            saml2Config.setMaximumAuthenticationLifetime(maximumAuthenticationLifetime);
        }
        if (serviceProviderEntityId != null) {
            saml2Config.setServiceProviderEntityId(serviceProviderEntityId);
        }
        if (serviceProviderMetadataPath != null) {
            saml2Config.setServiceProviderMetadataPath(serviceProviderMetadataPath);
        }
        saml2Config.setForceAuth(forceAuth);
        saml2Config.setPassive(passive);
        if (authnRequestBindingType != null) {
            saml2Config.setAuthnRequestBindingType(authnRequestBindingTypes.getOrDefault(authnRequestBindingType, authnRequestBindingType));
        }
        saml2Config.setUseNameQualifier(useNameQualifier);
        if (attributeConsumingServiceIndex >= 0) {
            saml2Config.setAttributeConsumingServiceIndex(attributeConsumingServiceIndex);
        }
        if (assertionConsumerServiceIndex >= 0) {
            saml2Config.setAssertionConsumerServiceIndex(assertionConsumerServiceIndex);
        }
        if (!blackListedSignatureSigningAlgorithms.isEmpty()) {
            saml2Config.setBlackListedSignatureSigningAlgorithms(blackListedSignatureSigningAlgorithms);
        }
        if (!signatureAlgorithms.isEmpty()) {
            saml2Config.setSignatureAlgorithms(signatureAlgorithms);
        }
        if (!signatureReferenceDigestMethods.isEmpty()) {
            saml2Config.setSignatureReferenceDigestMethods(signatureReferenceDigestMethods);
        }
        if (signatureCanonicalizationAlgorithm != null) {
            saml2Config.setSignatureCanonicalizationAlgorithm(signatureCanonicalizationAlgorithm);
        }
        saml2Config.setWantsAssertionsSigned(wantsAssertionsSigned);
        saml2Config.setAuthnRequestSigned(authnRequestSigned);
        saml2Config.setLogoutHandler((LogoutHandler)new DefaultLogoutHandler<J2EContext>(){

            public void destroySessionFront(J2EContext context, String key) {
                this.getStore().remove((Object)key);
                SessionStore sessionStore = context.getSessionStore();
                if (sessionStore == null) {
                    this.logger.error("No session store available for this web context");
                } else {
                    String currentSessionId = sessionStore.getOrCreateSessionId((WebContext)context);
                    if (currentSessionId != null) {
                        this.logger.debug("currentSessionId: {}", (Object)currentSessionId);
                        String sessionToKey = (String)this.getStore().get((Object)currentSessionId);
                        this.logger.debug("-> key: {}", (Object)key);
                        this.getStore().remove((Object)currentSessionId);
                        if (CommonHelper.areEquals((String)key, (String)sessionToKey)) {
                            this.destroy((WebContext)context, sessionStore, "front");
                        } else {
                            this.logger.error("The user profiles (and session) can not be destroyed for the front channel logout because the provided key is not the same as the one linked to the current session");
                        }
                    }
                }
            }
        });
        AxelorSAML2Client client = new AxelorSAML2Client(saml2Config);
        this.addClient((Client<?, ?>)client);
    }

    public static boolean isEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.get(CONFIG_SAML_KEYSTORE_PATH, null) != null;
    }

    private static class AxelorSAML2LogoutValidator
    extends SAML2LogoutValidator {
        private final String postLogoutURL;

        public AxelorSAML2LogoutValidator(SAML2SignatureTrustEngineProvider engine, Decrypter decrypter, LogoutHandler logoutHandler, String postLogoutURL) {
            super(engine, decrypter, logoutHandler);
            this.postLogoutURL = postLogoutURL;
        }

        public Credentials validate(SAML2MessageContext context) {
            if (context.getMessage() instanceof LogoutResponse && StringUtils.notBlank((CharSequence)this.postLogoutURL)) {
                LogoutResponse logoutResponse = (LogoutResponse)context.getMessage();
                SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
                this.validateLogoutResponse(logoutResponse, context, engine);
                throw HttpAction.redirect((WebContext)context.getWebContext(), (String)this.postLogoutURL);
            }
            return super.validate(context);
        }
    }

    private static class AxelorSAML2Client
    extends SAML2Client {
        public AxelorSAML2Client(SAML2Configuration configuration) {
            super(configuration);
            this.setName(((Object)((Object)this)).getClass().getSuperclass().getSimpleName());
        }

        protected void clientInit() {
            if (this.configuration.getServiceProviderEntityId() == null) {
                String serviceProviderEntityId = String.format("%s?client_name=%s", AuthPac4jModule.getCallbackUrl(), this.getName());
                this.configuration.setServiceProviderEntityId(serviceProviderEntityId);
            }
            super.clientInit();
        }

        protected void initSAMLLogoutResponseValidator() {
            String postLogoutURL = AuthPac4jModule.getRelativeBaseURL();
            this.logoutValidator = new AxelorSAML2LogoutValidator(this.signatureTrustEngineProvider, this.decrypter, this.configuration.getLogoutHandler(), postLogoutURL);
            this.logoutValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
        }
    }
}

