/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthService;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.auth.pac4j.AuthPac4jProfileService;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPac4jUserService {
    @Inject
    protected AuthService authService;
    @Inject
    protected AuthPac4jProfileService profileService;
    @Inject
    protected UserRepository userRepo;
    private static final String DEFAULT_GROUP_CODE;
    private static final Logger logger;

    @Nullable
    public User getUser(CommonProfile profile) {
        String codeOrEmail = this.profileService.getCodeOrEmail(profile);
        if (codeOrEmail != null) {
            return this.userRepo.findByCodeOrEmail(codeOrEmail);
        }
        return null;
    }

    public void saveUser(CommonProfile profile) {
        String codeOrEmail = this.profileService.getCodeOrEmail(profile);
        if (codeOrEmail == null) {
            return;
        }
        User user = this.userRepo.findByCodeOrEmail(codeOrEmail);
        if (user == null) {
            this.persistUser(codeOrEmail, profile);
        } else {
            this.updateUser(user, profile);
        }
    }

    public void updateUser(CommonProfile profile) {
        String codeOrEmail = this.profileService.getCodeOrEmail(profile);
        if (codeOrEmail == null) {
            return;
        }
        User user = this.userRepo.findByCodeOrEmail(codeOrEmail);
        if (user != null) {
            this.updateUser(user, profile);
        }
    }

    @Transactional
    protected void persistUser(String code, CommonProfile profile) {
        User user = new User(code, this.profileService.getName(profile));
        user.setPassword(UUID.randomUUID().toString());
        user.setEmail(this.profileService.getEmail(profile));
        user.setLanguage(this.profileService.getLanguage(profile, "en"));
        user.setGroup(this.profileService.getGroup(profile, this.getDefaultGroupCode()));
        this.profileService.getRoles(profile).forEach(user::addRole);
        this.profileService.getPermissions(profile).forEach(user::addPermission);
        try {
            user.setImage(this.profileService.getImage(profile));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.authService.encrypt(user);
        this.userRepo.persist(user);
        logger.info("User(code={}) created from {}", (Object)user.getCode(), (Object)profile);
    }

    @Transactional
    protected void updateUser(User user, CommonProfile profile) {
        Set<Permission> permissions;
        Set<Role> roles;
        Group group;
        String language;
        if (StringUtils.notBlank((CharSequence)profile.getDisplayName())) {
            user.setName(profile.getDisplayName());
        }
        if (StringUtils.notBlank((CharSequence)profile.getEmail())) {
            user.setEmail(profile.getEmail());
        }
        if (StringUtils.notBlank((CharSequence)(language = this.profileService.getLanguage(profile)))) {
            user.setLanguage(language);
        }
        if ((group = this.profileService.getGroup(profile)) != null) {
            user.setGroup(group);
        }
        if (!(roles = this.profileService.getRoles(profile)).isEmpty()) {
            user.clearRoles();
            roles.forEach(user::addRole);
        }
        if (!(permissions = this.profileService.getPermissions(profile)).isEmpty()) {
            user.clearPermissions();
            permissions.forEach(user::addPermission);
        }
        try {
            byte[] image = this.profileService.getImage(profile);
            if (ObjectUtils.notEmpty((Object)image)) {
                user.setImage(image);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String getDefaultGroupCode() {
        return DEFAULT_GROUP_CODE;
    }

    static {
        AppSettings settings = AppSettings.get();
        DEFAULT_GROUP_CODE = settings.get("auth.user.default.group", "users");
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

